#include "mbed.h"
#include "string.h"
#include "time.h"

//Used to run the code for the sensors touchsense1 and touchsense2 in the foreground.
Ticker sensor1;
Ticker sensor2;
void touchsense1(void);
void touchsense2(void);
DigitalOut myLed1(LED1);
DigitalOut myLed2(LED2);
DigitalOut myLed3(LED3);
AnalogIn input1(p20);
DigitalIn charger1(p19);
DigitalOut ground1(p18);
AnalogIn input2(p17);
DigitalIn charger2(p16);
DigitalOut ground2(p15);
Serial pc(USBTX,USBRX);

//Global variables for the touchsense1 and touchsense2 functions that are running in the foreground process.
bool isSensor1Pressed = false;
bool isSensor2Pressed = false;
int count = 0;
char triggerString1[1];
char triggerString2[1];
char realTriggerString[20];

//Foreground Task - 1
void touchsense1(void) 
{
    float sample;    
    ground1 = 0;
    charger1.mode(PullUp); //p19 used for charging the capacitor.
    charger1.mode(PullNone);
    sample = input1.read();
    if (sample < 0.3) 
    {
        triggerString1[0] = '0';
        myLed1 = 1;
        wait(0.01);
        isSensor1Pressed = true;
    } 
    else 
    {
        if (isSensor1Pressed) 
        {
             realTriggerString[count] = triggerString1[0];          
             count++;
        }
        myLed1 = 0;
        for (int i=0;i<strlen(triggerString1);i++) 
        {
            triggerString1[i] = '\0';
        }
        isSensor1Pressed = false; 
    }
}

//Foreground Task - 2
void touchsense2(void) 
{
    float sample;
   
    ground2 = 0;
    charger2.mode(PullUp);
    charger2.mode(PullNone);
    sample = input2.read();
    if (sample < 0.3) 
    {        
        triggerString2[0] = '1';
        myLed2 = 1;
        wait(0.01);
        isSensor2Pressed = true;
    } 
    else 
    {
        if (isSensor2Pressed) 
        {
             realTriggerString[count] = triggerString2[0];
             count++;
        }
        myLed2 = 0;
        for (int i=0;i<strlen(triggerString2);i++) 
        {
           triggerString2[i] = '\0';
        }
        isSensor2Pressed = false;
    }
}

int main() 
{
    char inputChar;     
    int countBits = 0;int k=0,counter=0,triggerStringlength;
    bool isStartEncountered = false; bool bitsEncountered = false;
    a:
    char triggerString[20];char triggerStringBits[20];counter = 0;
    pc.printf("Enter the Trigger String: ");
    while (1) 
    {
        pc.putc(inputChar = pc.getc());
        if (inputChar == 'e' || inputChar == 'E') 
        {
            triggerString[k] = inputChar;
            k++;
            break;
        } 
        else 
        {
            triggerString[k] = inputChar;
            k++;
        }
    }
    //All the entered characters from the user are strored in the array.
    triggerString[k] = '\0';
    //Getting the total length of the trigger string.
    while (triggerString[counter] != '\0') 
    {
        counter++;
    }
    triggerStringlength = counter;
    //Checking for the validity of the input validation string.
    for (int i = 0 ;i<triggerStringlength; i++) 
    {
        //If the input string does not start with required characters, then we continue.
       if(triggerString[0] != 's' && triggerString[0] != 'S')
        {
            pc.printf("\n\nInvalid Trigger String1\n");
            for(i=0;i<triggerStringlength;i++)
            {
                triggerString[i]='\0';                              
            }
            k=0;
            goto a;            
        }   
        
        for(int j=1;j<triggerStringlength-2;j++)
        {
            if(triggerString[j] == '0' || triggerString[j] == '1' || triggerString[j] == ' ')
            {
                continue;
            }
            else
            {
                pc.printf("\n\nInvalid Trigger String2\n");
                for(i=0;i<triggerStringlength;i++)
                {
                    triggerString[i]='\0';                              
                }
                 k=0;
                 goto a; 
            }
        }
        
            //If the input string contains spaces, simply continue.
            if (triggerString[i] == ' ') 
            {
                continue;
            }

            if (triggerString[i] == 'S' || triggerString[i] == 's') 
            {
                isStartEncountered = true;
                continue;
            }
        
        if (isStartEncountered && (triggerString[i]!= 'E' || triggerString[i] != 'e')) 
        {
            if (triggerString[i] == ' ') 
            {
                continue;
            } 
            else 
            {
                if (triggerString[i] == '0' || triggerString[i] == '1') 
                {
                    triggerStringBits[countBits] = triggerString[i];                   
                    bitsEncountered = true;
                    countBits++;
                }
            }
        } 
        else 
        {
            //If the user enters E character first without enterting the S character then the user has entered and invalid trigger string.
            if (isStartEncountered && !bitsEncountered && (triggerString[i] == 'E' || triggerString[i] == 'e')) 
            {
                pc.printf("Please enter a valid Trigger String");
            } 
            else 
            {
                if (isStartEncountered && (triggerString[i] == 'E' || triggerString[i] == 'e')) 
                {
                    break;
                }
            }
        }
    }
    //Ending the triggerString Bit array.
    triggerStringBits[countBits] = '\0';
    //Only after the trigger string is got from the user, the touch sensors need to be enabled.    
    pc.printf("\n\nPlease input on sensor:");
    //Enabling the sensors to run in the foreground process on a per second basis.
    sensor1.attach(&touchsense1,1);
    sensor2.attach(&touchsense2,1);    
    //Wait for 12 seconds for the input from the sensors.
    wait(countBits*3);
    //Marking the end of the trigger string captured through the sensors from the users. This value needs to be matched to the trigger string entered from the user through pc.
    realTriggerString[count] = '\0';  
    int matchCount = 0;
    //Only if the trigger string length equals the length of the string entered by the user, then only the validation for each character should take place.
    if (strlen(realTriggerString) == strlen(triggerStringBits)) {
        for (int i=0;i<strlen(realTriggerString);i++) {
            if (realTriggerString[i] == triggerStringBits[i]) {
                matchCount++;
            }
            //if (realTriggerString[i]== '0' || realTriggerString[i] == '1')
            //  pc.printf("%c",realTriggerString[i]);
        }
        if (matchCount == strlen(realTriggerString)) {
            pc.printf("HOST MATCH\n");
        }
    } 
    else 
    {
        pc.printf("HOST ERROR or TOUCH ERROR\n");
    }
}
    