/*#include "mbed.h"
#include "EthernetInterface.h"
 
#define PORT   54321
 
#define LEN_PACKET 1460
 
#define IP         "192.168.0.10"
#define GATEWAY    "192.168.0.1"
#define MASK       "255.255.255.0"
#define DES_ADDR   "192.168.0.12"
#define DES_LAPTOP "192.168.0.11"
 
#define LEN 18980
uint16_t sample_array0[LEN];
 
Serial pc(USBTX,USBRX);
 
int main (void) {
    for(int i = 0; i < LEN; i++) sample_array0[i] = ((0x0031<<8) | 0x0032);
    pc.baud(9600);
    pc.printf("Starting test client\r\n");
    EthernetInterface eth;
    eth.init(IP, MASK, GATEWAY);
    eth.connect();
    pc.printf("IP Address is %s\r\n", eth.getIPAddress());
    
    TCPSocketConnection mallet;
    mallet.set_blocking(false,5000);
    char buffer[LEN_PACKET];
    
    for(int i = 0; i < LEN_PACKET; i++) buffer[i] = i;
    while (true) {
        if(pc.readable() > 0){
            char temp = pc.getc();
            int var = 0;
            switch(temp){
                case 'Q':
                case 'q':
                    pc.printf("Intentando conectar a DES_LAPTOP (192.168.0.11) ..\n\r");
                    var = mallet.connect(DES_LAPTOP,PORT);
                    if(var == 0) pc.printf("Connected to laptop successfully\r\n");
                    else if(var == -1) pc.printf("Connecting failed\r\n");
                    break;
                case 'A':
                case 'a':
                    pc.printf("Intentando conectar a DES_ACER (192.168.0.12) ..\n\r");
                    var = mallet.connect(DES_ADDR,PORT);
                    if(var == 0) pc.printf("Connected to ACER server successfully\r\n");
                    else if(var == -1) pc.printf("Connecting failed\r\n");
                    break;
                case 'S':
                case 's':
                    pc.printf("Enviando informacion..\n\r");
                    var = mallet.send(buffer,LEN_PACKET);
                    pc.printf("Sent %i bytes\r\n",var);
                    break;
                case 'D':
                case 'd':
                    pc.printf("Recibiendo informacion..\n\r");
                    var = mallet.receive_all((char *)sample_array0,LEN*2);
                    pc.printf("Received %i bytes\r\n",var);
                    break;
                case 'F':
                case 'f':
                    pc.printf("Cerrando conexion..\n\r");
                    var = mallet.close();
                    if(var == 0) pc.printf("Connection closed\r\n");
                    else pc.printf("Error while closing connection\r\n");
                    break;
                case 'Z':
                case 'z':
                    pc.printf("Status: ");
                    if(mallet.is_connected()) pc.printf("Connected\r\n");
                    else pc.printf("Not connected\r\n");
                    break;
                case 'R':
                case 'r':
                    pc.printf("Haciendo todo un proceso de abrir socket y enviar informacion..\n\r");
                    // open connection
                    var = mallet.connect(DES_ADDR,PORT);
                    if(var == 0) pc.printf("Connected successfully\r\n");
                    else if(var == -1) pc.printf("Connection already open\r\n");
                    
                    // send data
                    var = mallet.send(buffer,LEN_PACKET);
                    pc.printf("Sent %i bytes\r\n",var);
                    
                    // receive data
                    var = mallet.receive_all((char *)sample_array0,LEN*2);
                    pc.printf("Received %i bytes\r\n",var);
                    
                    // closed connection
                    var = mallet.close();
                    if(var == 0) pc.printf("Connection closed\r\n\n");
                    else pc.printf("Error while closing connection\r\n\n");
                    break;
                case 'L':
                case 'l':
                    for(int i = 0; i < 1000; i++){
                        //wait_ms(100);
                        pc.printf("%3i: ",i);
                        
                        // open connection
                        var = mallet.connect(DES_ADDR,PORT);
                        if(var == -1) {i = 50; break;}
                        
                        // send data
                        var = mallet.send(buffer,LEN_PACKET);
                        pc.printf("Sent %i: ",var);
                        if(var == -1) {i = 50; break;}
                        
                        // receive data
                        var = mallet.receive_all((char *)sample_array0,LEN*2);
                        pc.printf("Rec %i: ",var);
                        if(var == -1) {i = 50; break;}
                        
                        // closed connection
                        var = mallet.close();
                        if(var == -1) {i = 50; break;}
                        pc.printf("\r\n");
                        
                    }
                    break;
            }
        }
    }
}
*/