#include "mbed.h"
#include "EthernetInterface.h"
 
#define IP         "192.168.1.10"
#define GATEWAY    "192.168.1.1"
#define MASK       "255.255.255.0"
#define DES_ADDR   "192.168.1.12"
#define DES_LAPTOP "192.168.1.11"

#define PORT        54321

Serial pc(USBTX,USBRX);

int main() {
    
    int resul=-1;
    pc.baud(9600);
    
    /** Configuramos el puerto ethernet **************************************************/
    EthernetInterface eth;
    pc.printf("Inicializando el puerto ethernet... \n\r");
    //resul=eth.init(IP,MASK,GATEWAY); 
    resul=eth.init();
    if(resul==0)pc.printf("Puerto ethernet inicializado correctamente..\n\r");
    
    pc.printf("Obteniendo direccion IP...resul=%d\n\r",resul);
    resul=eth.connect();
    
    if(resul==0)
        pc.printf("IP Address is %s\n", eth.getIPAddress());
    else
        pc.printf("Fallo la conexion...IP Address is %s\n\r",eth.getIPAddress());
    /* Terminada la configuración del ethernet */
    
    /** Creamos el nodo servidor *****************************************************/
    TCPSocketServer server;             //crea el objeto de tipo servidor
    server.bind(PORT);                   //Enlaza el socket server a un puerto
    server.listen();                    //Queda escuchando por una nueva conexion.
    /*********************************************************************************/
    
    /** Esperamos por la conexion de un cliente **************************************/
    while (true) {
        printf("\nWait for new connection...\n\r");
        TCPSocketConnection client;     //creamos un nuevo cliente
        server.accept(client);          //aceptamos la conexión de una nuevo cliente
        client.set_blocking(true, 1500); // Timeout after (1.5)s
        
        printf("Connection from: %s\n", client.get_address());
        
        //Define useful variables
        char buffer[256];
        char command[20];
        
        
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            
            // print received message to terminal
            buffer[n] = '\0';
            printf("Received message from Client :'%s'\n\r",buffer);
            
            sscanf(buffer,"%s",command);
            printf("Command detected :'%s'\n\r",command);
            
            if(strcmp(command,"Hello")==0)
            {
                    pc.printf("He recibido el comando Hello...\n\r");
                    sprintf(buffer,"%d",1);
                    client.send_all(buffer, sizeof(buffer));
            }        
            else
                    pc.printf("Command not identified.. \n\r");
        
            
            
                /*printf("Received message from Client :'%s'\n\r",buffer); 
                // reverse the message
                char temp;
                for(int f = 0, l = n-1; f<l; f++,l--){
                    temp = buffer[f];
                    buffer[f] = buffer[l];
                    buffer[l] = temp;
                    }
            
                 // print reversed message to terminal
                printf("Sending message to Client: '%s'\n\r",buffer);
            
                // Echo received message back to client
                client.send_all(buffer, n);
                if (n <= 0) break;*/
        }
        pc.printf("El cliente se ha desconectado..\n\r");
        client.close();
    }
        
}