/*#include "mbed.h"
#include "EthernetInterface.h"
 
#define ECHO_SERVER_PORT   54321
 
#define IP "192.168.0.10"
#define GATEWAY "192.168.0.1"
#define MASK "255.255.255.0"
 
#define LEN 18980
uint16_t sample_array0[LEN];
 
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalOut led_blue(LED_BLUE);
 
Serial pc(USBTX,USBRX);
 
int main (void) {
    for(int i = 0; i < LEN; i++) sample_array0[i] = ((0x0031<<8) | 0x0032);
    sample_array0[0] = ('S'<<8)|'S';
    sample_array0[LEN-1] = ('F'<<8) | 'F';
    pc.baud(9600);
    pc.printf("Starting test server\r\n");
    
    EthernetInterface eth;
    eth.init(IP, MASK, GATEWAY);
    eth.connect();
    pc.printf("IP Address is %s\r\n", eth.getIPAddress());
    
    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();
    
    led_blue = 1;
    led_green = 1;
    led_red = 1;
    
    while (true) {
        //pc.printf("\r\nWait for new connection...\r\n");
        
        
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(true, 5000);
            
        //pc.printf("Connection from: %s\r\n", client.get_address());
        char buffer[1460]; // size of IP payload
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;
            pc.printf("Rec: %i: ",n);
            
 
            n = client.send_all((char *)sample_array0, LEN*2);
            
            if (n <= 0) {led_blue = 0; break;}
            pc.printf("Sent %i: ",n);
        }
        
        client.close();
        pc.printf("\r\n");
    }
}*/