// Encoder lib for user interfaces
// Use this file for configuring the pins, timings etc.
/*
The MIT License (MIT)

Copyright (c) 2014 calima engineering

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef ENCODER_CONFIG_H_
#define ENCODER_CONFIG_H_

#include "project.h"

// Chose encoder pins
// First tested with Nucleo STM32F302
#define ENCODER_PIN_A D6
#define ENCODER_PIN_B D7
#define ENCODER_PIN_PB D5

// Sample every ... microseconds, default
// 250µs is a good value for cheap 24 ppr encoders (ALPS EC12E24...) with strong bouncing.
// 1000µs is a good value for quality 24 ppr encoders (ALPS EC12E24...) with low bouncing.
// 250µs is a good value for fast 24+ ppr encoders (Sparkfun, Some Bourns types, ...).
#define ENCODER_SAMPLE_PERIOD_US (250)

// Pushbutton debouncing in milliseconds
#define ENCODER_PB_DEBOUNCE_MS (125uL)


#endif // ENCODER_CONFIG_H_