/* Testing the overflow of Timer
LCD on I2C bus, PCF8574
 */
#include "mbed.h"
#include "TextLCD.h"

Timer t;

I2C i2c_lcd(I2C_SDA,I2C_SCL); // SDA, SCL

TextLCD_I2C lcd(&i2c_lcd, 0x40, TextLCD::LCD16x2); // I2C bus, PCF8574 Slaveaddress, LCD Type

// Trick to change baudrate of stdout, SFord
void baud(int baudrate)
{
    Serial s(USBTX, USBRX);
    s.baud(baudrate);
}

int main()
{
    uint32_t    Millis, LastMillis;
    baud(921600);   // see function above
    i2c_lcd.frequency(400000);  // 400KHz
    lcd.setCursor(lcd.CurOff_BlkOff); // Cursor off, Blink off
    lcd.cls();
    lcd.setBacklight(TextLCD::LightOn);
    lcd.locate(0,0);  // Goto beginning of line = second par.
    lcd.printf("Testing Timer...\n");
    lcd.locate(0,1);  // Goto beginning of line = second par.
    lcd.printf("...us overflow  \n");
    printf("\nTesting Timer us overflow..\n");

    t.reset();
    t.start();

#define TIMER_MASK (0x1000uL - 1)

    Millis = t.read_ms() & TIMER_MASK;
    lcd.locate(0,1);  // Goto beginning of line = second par.
    lcd.printf("Start M: %08d",Millis);

    do {
        LastMillis = Millis;
        Millis = t.read_ms() & TIMER_MASK;
    } while(LastMillis <= Millis);

    lcd.locate(0,0);  // Goto beginning of line = second par.
    lcd.printf("Last M: %08d",LastMillis);
    lcd.locate(0,1);
    lcd.printf("Act. M: %08d",Millis);

    printf("Last Millis: %08d\n",LastMillis);
    printf("Act. Millis: %08d\n",Millis);
}
