/*
 * Author: Edoardo De Marchi
 * Date: 20/07/16
 * Notes: Test ethernet server (for Android connection)
*/

#include "main.h"



int Init()
{
    led1 = 0;               
    led2 = 0;              
    led3 = 0;              
    led4 = 0;               
    
       
    // ETHERNET
    eth.init(ip, mask, gateway);
    eth.connect();
    server.bind(ECHO_SERVER_PORT);
    server.listen(1);
    pc.printf("IP Address is %s\r\n", eth.getIPAddress());
    
    pc.printf("%s  - speed: %d Mbps\n", get_transmission_status(), get_connection_speed());
   
    // THREAD 
    osThreadCreate(osThread(net_thread), NULL);
            
    return 0;
}




int main (void) 
{
    bool eth_status = false;
    bool eth_status_temp = true;
 
    Init();
    
    while (true)
    {        
        if(!get_link_status())
        {
            eth_status = true; 
        }else
        {
            eth_status = false;
            eth_status_temp = true;
            led1 = 0;                           
        }
        
        if(eth_status == eth_status_temp)
        {
            eth_status_temp = !eth_status;
            pc.printf("Check cable connection\r\n");
            led1 = 1;
            eth_status = false;
            if(checketh)
            {
                client.close();
                pc.printf("Connection close.\r\n");
                checketh = false;
            }
        }
        led2 = !led2;          
        osDelay(500);
    }     
}


void net_thread(void const *argument)
{
    while (true) 
    {
        led3 = 1;
        server.accept(client);
        checketh = true;
        pc.printf("Connection from: %s\r\n", client.get_address());
        while (true) 
        {
            led3 = 0;
            int n = client.receive(bufferRX, sizeof(bufferRX));  // ritorna il numero di byte spediti
            if (n <= 0) break;
            
            bufferRX[n]=0; // make terminater
            parse_cmd(n);
        }
        checketh = false;
        client.close();
        pc.printf("Connection close.\r\n");  
    } 
} 


void parse_cmd(int sizeCMD)
{
            new_send = false;
            printf("cmd << %s\r\n", bufferRX);
            
            sprintf(bufferTX, "CMD Received\r\n");
            client.send_all(bufferTX, sizeof(bufferTX));
            
            memset(bufferTX, 0, sizeof(bufferTX));                                             
            memset(bufferRX, 0, sizeof(bufferRX));           
}