#pragma once 
#include "mbed.h"
#include "TEA5767.h"
#include "MODSERIAL.h"

DigitalOut led2(LED2);
DigitalOut led4(LED4);

//WATCHDOG
class Watchdog 
{
public:
    void kick(float s) 
    {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4 
        LPC_WDT->WDTC = s * (float)clk;         
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset        
        kick();
    }
    
    void kick() 
    {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};
 
Watchdog w;



// TEA5767  IC2 address is 0x60, reading is 0x61
#define W_ADDR 0xC0

MODSERIAL pc(USBTX,USBRX);

TEA5767 radio(p28, p27, W_ADDR);        // sda - scl
bool new_send = false;
char word[25];
float n = 0;
char reg[5];
float StartFreq = 87.5;
float EndFreq = 108;

//RESET
extern "C" void mbed_reset();



void parse_cmd();
