/*
 * Author: Edoardo De Marchi
 * Date: 05/10/13
 * Notes: Test code for TEA5767 radio module
*/

#include "main.h"

void rxCallback(MODSERIAL_IRQ_INFO *q) 
{
     new_send = true;
}


int main()
{
    // INIT WATCHDOG
    w.kick(2.5);
    
    pc.baud(921600);
    pc.attach(&rxCallback, MODSERIAL::RxIrq);
    
    if(radio.CheckDevice() == 0)
    {   
        pc.printf("Addr I2C found\r\n");
        led2 = 1;
    }else
    {
        pc.printf("Addr I2C not found\r\n");
        led2 = 0;    
    }
    
    while(1) 
    { 
        if(new_send){
            int i = 0;
       
            while(pc.readable())
            {
                word[i] = pc.getc();
                i++;
            }
            parse_cmd(); 
        }            
        wait_ms(50);
        w.kick();
    }
}


// US-EUROPE 87.5-108MHz   JAPANESE 76-91MHz
float i = 0.2;
void parse_cmd()
{
        new_send = false;
        
        if(strncmp("freq", word, 4) == 0)              
        {
            char word_temp[6];
            strncpy(word_temp, &word[5], 6);
  
            n = atof(word_temp);                        // Convert string to double
            
            if((n >= StartFreq) && (n <= EndFreq))
            {
                radio.SetFrequency(n);
                
                wait_ms(200);

                pc.printf("signal: %2.0d", radio.SignalLevel());
                pc.printf("freq: %000.2f ", radio.FreqCurrent());
                delete [] reg;
                wait_ms(100);
                    
            }else
            {
                pc.printf("Out of range \r\n");       
            }
        }else
        if(strncmp("available", word, 9) == 0)              
        {
            pc.printf("\r\n"); 
            pc.printf("Current_Frequency: %.2fMHz\r\n", radio.FreqCurrent());
            pc.printf("Signal_Level: %2.0d\r\n", radio.SignalLevel());
        }else
        if(strncmp("search_up", word, 9) == 0)              
        {
            float freq_av = radio.FreqCurrent();
            if(freq_av-i > 108)
            {
                freq_av = 108;
            }
            radio.SearchUp(freq_av+i);
            wait_ms(700);
            pc.printf("signal: %2.0d", radio.SignalLevel());
            pc.printf("freq: %000.2f ", radio.FreqCurrent());
        }else
        if(strncmp("search_down", word, 11) == 0)              
        {    
            float freq_av = radio.FreqCurrent();
            if(freq_av-i < 87.5)
            {
                freq_av = 87.5;
            }
            radio.SearchUp(freq_av-i);
            wait_ms(700);
            pc.printf("signal: %2.0d", radio.SignalLevel());
            pc.printf("freq: %000.2f ", radio.FreqCurrent());                      
        }else
        if(strncmp("band", word, 4) == 0)              
        {
            char word_temp[2];
            strncpy(word_temp, &word[5], 2);      
            pc.printf("string: %s\r\n", word_temp);
            
            if(strncmp("EU", word_temp, 2) == 0)
            {
                radio.SetBand('e');
                StartFreq = 87.5;
                EndFreq = 108;
            }else
            if(strncmp("JP", word_temp, 2) == 0)
            {
                radio.SetBand('j');
                StartFreq = 76;
                EndFreq = 91;
            }
        }
            
        memset(word, 0, sizeof(word));
}

