#include "TEA5767.h"


TEA5767::TEA5767(PinName sda, PinName scl, int addr) : i2c(sda, scl), addr(addr)
{   
    SetBand('e'); 
    Init();
}


TEA5767::~TEA5767()
{
}


void TEA5767::Init()
{
    if(band == 'e')
    {
        SetFrequency(87.5, 'h');  // starting frequency
    }else
    {
        SetFrequency(76, 'h');  // starting frequency
    }
}


void TEA5767::SetBand(char valueBand)
{
    if(valueBand == 'e' | valueBand == 'j')
        band = valueBand;        
}


void TEA5767::SetFrequency(double freq, char side)
{
    frequency = SideInjection(freq, side);
    SetData(frequency);
}


unsigned int TEA5767::SideInjection(float freq, char mode)
{
    side = mode;
    if(side == 'h')
    {
        // IF = 225KHz
        unsigned int N_h = (4 * (freq * 1000000 + 225000)) / 32768;             // formula for high side injection
        return N_h;                                                             // return PLL word
    }else
    {
        unsigned int N_l = (4 * (freq * 1000000 - 225000)) / 32768;             // formula for low side injection 
        return N_l;                                                             // return PLL word
    }    
}


void TEA5767::SearchUp(float freq)
{
    SetData(SideInjection(freq, 'h'), 0x40, 0xd0, 0x10, 0x00);
}


void TEA5767::SearchDown(float freq)
{
    SetData(SideInjection(freq, 'h'), 0x40, 0x50, 0x10, 0x00);
}


float TEA5767::FreqCurrent()
{
    char buf_temp[5];
    GetData(buf_temp);
    frequency = ((buf_temp[0]&0x3f)<<8) | buf_temp[1];

    if(side == 'h')
    {
        return (((((float)frequency*32768)/4)-225000)/1000000);
    }else
    {
        return (((((float)frequency*32768)/4)+225000)/1000000);
    }
}


void TEA5767::SetData(unsigned int N, char data_1, char data_3, char data_4, char data_5)
{   

        
        char buf[5];
        char freqMSB = N >> 8;     // 1st 6bit
        char freqLSB = N & 0xff;   // 2nd 8bit
        
        buf[0] = ((data_1 & 0xc0) | freqMSB);
        buf[1] = freqLSB;
        buf[2] = data_3;  
        if(band == 'e')
        {
            buf[3] = data_4 & 0xdf; 
        }else
        {
            buf[3] = data_4 | 0x10; 
        }          
        buf[4] = data_5;
        
        i2c.write(addr, buf, 5);
}



void TEA5767::GetData(char* reg)
{
        memset(reg, 0, sizeof(reg));
        i2c.read(addr, reg, 5);      
}


int TEA5767::CheckDevice()
{ 
    return i2c.write(addr, NULL, 0); 
}


int TEA5767::SignalLevel()
{
    char reg[5];
    GetData(reg);
    return ((reg[3]&0xf0)>>4);
}

