#pragma once 
#include "mbed.h"
#include "ov7670.h"
#include "EthernetInterface.h"


#define ECHO_SERVER_PORT   2000


Timer t;
bool new_send = false;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);


//Camera
OV7670 camera
(
    p28,p27,                // SDA,SCL(I2C / SCCB)
    p23,NC,p25,             // VSYNC,HREF,WEN(FIFO)  
    Port0,0x07878000,       // PortIn data        p18(P0.26),p17(P0.25),p16(P0.24),p15(P0.23),p11(P0.18),p12(P0.17),p14(P0.16),p13(P0.15)
    p26,p29,p30             // RRST,OE,RCLK
); 


//ETHERNET
char* ip = "192.168.153.153";             // ip
char* mask = "255.255.255.0";           // mask
char* gateway = "192.168.153.130";          // gateway
EthernetInterface eth;
TCPSocketConnection client;
TCPSocketServer server; 


//ETHERNET BUFFER
char bufferRX[20];
char bufferTX[4800];

char *StartCondition = "sRt";        // START
bool bGrab_on = false;
bool bSnap_on = false;


//RESET
extern "C" void mbed_reset();


//TIMER
int t1 = 0; 
int t2 = 0;


//THREAD
void Net_Thread(void const *argument);
void Grab_Thread(void const *argument);
osThreadId tencid;
osThreadDef(Net_Thread, osPriorityNormal, DEFAULT_STACK_SIZE); 
osThreadDef(Grab_Thread, osPriorityNormal, DEFAULT_STACK_SIZE);


//FUNCTION
void Send();
void parse_cmd(int sizeCMD);
void CameraSnap();
void CameraGrab();


struct CameraSet
{
    char format[3];
    int resolution;
}CMDCamera;


struct Register
{
    char type;
    int addr;
    int value;
}Reg;
