/*
 * Author: Edoardo De Marchi
 * Date: 05/04/14
 * Notes: This firmware required "OV7670 Grabber v2.0"
*/

#include "main.h"

#define VGA     307200         //640*480
#define QVGA    76800          //320*240
#define QQVGA   19200          //160*120


int Init()
{
    led1 = 0;               
    led2 = 0;        // mbed status       
    led3 = 0;        // Ethernet link enable/disable      
    led4 = 0;        // Snap status       
      
    //ETHERNET
    //Static IP
    eth.init(ip, mask, gateway);
    //DHCP
    //eth.init();
    
    eth.connect();
    server.bind(ECHO_SERVER_PORT);
    server.listen(1);
    
    printf("IP Address is %s\r\n", eth.getIPAddress());
    
    //THREAD 
    osThreadCreate(osThread(Net_Thread), NULL);
    tencid = osThreadCreate(osThread(Grab_Thread), NULL);  
    
    return 0;
}


void Net_Thread(void const *argument)
{
    while (true) 
    {
        led3 = 1;
        server.accept(client);
        printf("Connection from: %s\r\n", client.get_address());
        
        while (true) 
        {
            led3 = 0;
            int n = client.receive(bufferRX, sizeof(bufferRX));  
            if (n <= 0) break;
            
            bufferRX[n]=0; // make terminater
            parse_cmd(n);
        }
        client.close();
    } 
} 


void Send()
{
        client.send_all(bufferTX, sizeof(bufferTX));
        memset(bufferTX, 0, sizeof(bufferTX));
}


void Grab_Thread(void const *argument)
{
    while(true)
    {    
        osSignalWait(0x1, osWaitForever);
                    
        while(bSnap_on || bGrab_on)
        {
            CameraSnap();
            bSnap_on = false;
        }
    }
}


void CameraSnap()
{
        led4 = 1;
        int p = 0;  

        camera.CaptureNext();
        while(camera.CaptureDone() == false);      
                                 
        camera.ReadStart();                             // Start reading in the image data from the camera hardware buffer  
        
        t1 = t.read_ms(); 
                  
        client.send_all(StartCondition, sizeof(StartCondition));
                    
        if(strcmp("BAW", CMDCamera.format) == 0 || strcmp("RAW", CMDCamera.format) == 0)                   // B&W  
        {  
            for(int x = 0; x<CMDCamera.resolution/sizeof(bufferTX); x++)
            {
                for(int q = 0; q<sizeof(bufferTX); q++)
                {               
                   if(CMDCamera.resolution != VGA)
                        camera.ReadOnebyte();                   // Read in the first half of the image
                   
                   bufferTX[q] = camera.ReadOnebyte();          // Y only      // Read in the Second half of the image                                  
                }  
                Send();       
            } 
        }     
        
        if(strcmp("YUV", CMDCamera.format) == 0 || strcmp("RGB", CMDCamera.format) == 0)                    // Color
        {
            for(int x = 0; x<(CMDCamera.resolution/sizeof(bufferTX))*2; x++)
            {
                for(int q = 0; q<sizeof(bufferTX)/2; q++)
                {
                       p = q*2;                               
                       bufferTX[p] = camera.ReadOnebyte();          // Read in the first half of the image                       
                       bufferTX[p+1] = camera.ReadOnebyte();        // Read in the Second half of the image                      
                }  
                Send();       
            }         
        }       
           
        camera.ReadStop();               
        t2 = t.read_ms(); 
                                      
        led4 = 0;
}


int main (void) 
{
    led3 = 0;
    int iRet=Init();

    if (iRet<0)
    {
        printf("Init Error!");
        return iRet;
    }
    t.start();
    
    while (true)
    {
        //mbed is alive?
        led2 = !led2;
        osDelay(500);
    }     
}


void parse_cmd(int sizeCMD)
{
            new_send = false;
            //printf("bufferRX: %s\r\n", bufferRX);
            
            if(strcmp("snap", bufferRX) == 0)              
            {
                    bSnap_on = true;
                    osSignalSet(tencid, 0x1);
                    memset(bufferRX, 0, sizeof(bufferRX));      
            }else
            if(strncmp("grab", bufferRX, 4) == 0)               // grab start       grab stop  
            {
                    if(strncmp("start", &bufferRX[5], 5) == 0)
                    {
                        bGrab_on = true;
                        osSignalSet(tencid, 0x1);
                        memset(bufferRX, 0, sizeof(bufferRX));
                    }else
                    {
                        bGrab_on = false;
                        memset(bufferRX, 0, sizeof(bufferRX));
                    }      
            }else
            if(strncmp("init", bufferRX, 4) == 0)               // init RGB 19200
            {
                    char word[10];
                    strncpy(CMDCamera.format, &bufferRX[5], 3);
                    strncpy(word, &bufferRX[9], sizeCMD-9);                  
                    CMDCamera.resolution = atoi(word);
                    
                    printf("CMDCamera.format: %s\r\n", CMDCamera.format);
                    printf("CMDCamera.resolution: %d\r\n", CMDCamera.resolution); 

                    if(camera.Init(CMDCamera.format, CMDCamera.resolution) != 1)
                    {
                      printf("Init Fail\r\n");
                    }
                    
                    sprintf(bufferTX, "OV Init OK\r\n");
                    client.send_all(bufferTX, sizeof(bufferTX));
                    memset(bufferRX, 0, sizeof(bufferRX));
            }else 
            if(strncmp("reg", bufferRX, 3) == 0)                // reg r 018       reg w 018 004        reg 
            {        
                    if(!bGrab_on)
                    {
                        strncpy(&Reg.type, &bufferRX[4], 1);
                        char word[3];                    
                    
        
                        if(Reg.type == 'r')
                        {
                            strncpy(word, &bufferRX[6], 3);
                            Reg.addr = atoi(word);
                            memset(word, 0, sizeof(word));
                            sprintf(bufferTX, "reg: %x", camera.ReadReg(Reg.addr));  
                        }else
                        {
                            strncpy(word, &bufferRX[6], 3);
                            Reg.addr = atoi(word);
                            strncpy(word, &bufferRX[10], 3);
                            Reg.value = atoi(word);
                            memset(word, 0, sizeof(word));
                            camera.WriteReg(Reg.addr, Reg.value);
                            sprintf(bufferTX, "%x", camera.ReadReg(Reg.addr));
                        }
                        if(sizeCMD == 3)
                        {
                            int n = 0;
                            int g = 0;
                            int c = 650;
                            sprintf(bufferTX, "reg_tab: ");
                            for (int i=0;i<201;i++) 
                            {
                                n = snprintf(9+bufferTX+g, c, "%02X", camera.ReadReg(i));
                                g = g + n; 
                                c = c - n - 1;                                          
                            }                  
                            client.send_all(bufferTX, sizeof(bufferTX));                      
                        }
                  
                        client.send_all(bufferTX, sizeof(bufferTX));
                    }
            }else
            if(strncmp("w_bit", bufferRX, 5) == 0)                  //  w_bit0 018 001         w_bit1 018 001 
            {        
                    int type;
                    int reg_addr = 0;                
                    int reg_value = 0;
                    char word[3];
                    strncpy(word, &bufferRX[5], 1); 
                    type = atoi(word);
                    strncpy(word, &bufferRX[7], 3);  
                    reg_addr = atoi(word);
                    memset(word, 0, sizeof(word));
                    strncpy(word, &bufferRX[11], 3); 
                    reg_value = atoi(word); 
                    //printf("reg read write: addr: %x - value %x\r\n", reg_addr, reg_value);
                    int reg_value_now = camera.ReadReg(reg_addr);
                    
                    if(type == 0)
                    {
                        reg_value = reg_value_now ^ reg_value; 
                    }else
                    {
                        reg_value = reg_value_now | reg_value;
                    }
                    //printf("reg value new: reg_value_now: %x - reg_value %x\r\n", reg_value_now, reg_value);                   
                    camera.WriteReg(reg_addr, reg_value);
                    memset(word, 0, sizeof(word));
                    memset(bufferTX, 0, sizeof(bufferRX));
            }else
            if(strcmp("reset", bufferRX) == 0)              
            {
                    mbed_reset();        
            }else
            if(strcmp("time", bufferRX) == 0)              
            {
                    sprintf(bufferTX, "OV Tot time acq + send (mbed): %dms\r\n", t2-t1);                  
                    client.send_all(bufferTX, sizeof(bufferTX));
                    memset(bufferTX, 0, sizeof(bufferTX));
            }else   
            if(strcmp("ciao", bufferRX) == 0)              
            {
                    sprintf(bufferTX, "OV Test OK\r\n");                   
                    client.send_all(bufferTX, sizeof(bufferTX));
                    memset(bufferTX, 0, sizeof(bufferTX));                         
            }            
            memset(bufferRX, 0, sizeof(bufferRX));           
}
