/*
 * Author: Edoardo De Marchi
 * Date: 10/03/13
 * Notes: OV7670 + FIFO AL422B camera test
*/

#include "main.h"

#define QQVGA 4         //320*240
#define QVGA 2          //160*120


void rxCallback(MODSERIAL_IRQ_INFO *q) 
{
     new_send = true;
}

int main() 
{  
    pc.baud(921600);       
    pc.printf("SystemCoreClock: %dMHz\r\n", SystemCoreClock/1000000);       // print the clock frequency
    led4 = 0;
  
    t.start();
    pc.attach(&rxCallback, MODSERIAL::RxIrq);

    while(1) 
    { 
        if(new_send){
            int i = 0;
       
            while(pc.readable())
            {
                word[i] = pc.getc();
                i++;
            }
            parse_cmd(); 
        }            
        wait_ms(50);
    }
}



void parse_cmd(){
            new_send = false;
            
            if(strcmp("snap_yuv", word) == 0)              
            {
                    CameraSnap('y');
                    memset(word, 0, sizeof(word));      
            }else
            if(strcmp("snap_rgb", word) == 0)              
            {
                    CameraSnap('r');
                    memset(word, 0, sizeof(word));
                   
            }else        
            if(strcmp("init_yuv", word) == 0)              
            {
                    // Reset camera on power up
                    camera.Reset();
                            // Set up for 160*120 pixels YUV (Only Y)
                    pc.printf("Initializing ov7670 - Format YUV & QQVGA Mode\r\n");
                    if(camera.Init('y') != 1)
                    {
                      pc.printf("Init Fail\r\n");
                    }
                    pc.printf("Initializing done\r\n");
                    memset(word, 0, sizeof(word));
            }else
            if(strcmp("init_rgb", word) == 0)              
            {
                    // Reset camera on power up
                    camera.Reset();
                            // Set up for 160*120 pixels RGB565
                    pc.printf("Initializing ov7670 - Format RGB & QQVGA Mode\r\n");
                    if(camera.Init('r') != 1)
                    {
                      pc.printf("Init Fail\r\n");
                    }
                    pc.printf("Initializing done\r\n");
                    memset(word, 0, sizeof(word));
            }else
            if(strcmp("reset", word) == 0)              
            {
                    mbed_reset();        
            }else
            if(strcmp("time", word) == 0)              
            {
                    pc.printf("Time Acq from camera: %dms - Time Send to pc: %dms - Time Tot: %dms\r\n", t2-t1, t3-t2, t3-t1);
                    memset(word, 0, sizeof(word));
            } 
            memset(word, 0, sizeof(word));
            
}



void CameraSnap(char c){
        led4 = 1;
        int var2 = 0;
        int var = 0;
        t1 = t.read_ms();
         
                // wait until the image has been captured
        camera.CaptureNext();
        while(camera.CaptureDone() == false);
       
                // Start reading in the image data from the camera hardware buffer                   
        camera.ReadStart();  
        
               // Read the first half of the image
        for (int q = 0; q < SIZE; q++) 
        {
                bank0[q] =  camera.ReadOnebyte();
        }
               // Read the Second half of the image
        for (int q = 0; q < SIZE; q++) 
        {
                bank1[q] =  camera.ReadOnebyte();
        }
        
                // Stop reading the image
        camera.ReadStop() ; 
        t2 = t.read_ms();          
        
        if(c == 'y')
        {
            var = 2;                    // set YUV QQVGA
            var2 = 1;
        }
        else{
            var = 1;                    // set RGB565 QQVGA  
            var2 = 0;
        }
        
        for (int i = 0; i < SIZE/var; i++) {
            pc.putc(bank0[(i*var)+var2]);       
        }
        for (int i = 0; i < SIZE/var; i++) {
            pc.putc(bank1[(i*var)+var2]);       
        }
     
                 // Immediately request the next image to be captured
        camera.CaptureNext();                             
        while (camera.CaptureDone() == false);
        t3 = t.read_ms();
        
        pc.printf("Grab done\r\n"); 
            
        led4 = 0;
}


