/*
 * Author: Edoardo De Marchi
 * Date: 14-01-2017
 * Notes: Send the temperature value over MQTT protocol
*/


#include "main.h"


void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    

    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload [len: %d] %s\n", message.payloadlen, message.payload);
    
    memset(bufMQTT, 0, sizeof(bufMQTT));
    message.payloadlen = 0;
}






// Thread that read the temperature from LM75 sensor
void temp_sensor_thread(void const *argument)
{
    while (true) 
    {
        if(bStart)
        {
            
            // Read Temperature
            fTemperature = TempSensor.read_T();
            if(fTemperature != fTemperatureTemp)
            {         
                int len = sprintf(bufMQTT, "The room temperature is: %4.2f degree C\n", fTemperature);
                
                fTemperatureTemp = fTemperature;
                bNewValue = true;
            }
    
            led3 = !led3;
        
        }
        
        osDelay(1000);  
    } 
} 







void init()
{
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 0;
    
    
    // Create Thread
    osThreadCreate(osThread(temp_sensor_thread), NULL); 
}




int main(int argc, char* argv[])
{   

   
    init();

    printf("Connecting to %s:%d\n", hostbroker, port);
        
    
    // dhcp
    MQTTEthernet ipstack = MQTTEthernet();


    EthernetInterface& eth = ipstack.getEth();
    printf("IP addr is %s\n", eth.getIPAddress());
    printf("MAC addr is %s\n", eth.getMACAddress());
    printf("Gateway addr is %s\n", eth.getGateway());


    MQTT::Client<MQTTEthernet, Countdown> clientMQTT = MQTT::Client<MQTTEthernet, Countdown>(ipstack);


    // tcp connection
    if ((rc = ipstack.connect(hostbroker, port)) != 0)
    {
        printf("rc from TCP connect is %d\n", rc);
    }else
    {
        printf("TCP connection OK\n");
        led1 = 1;       
    }



    // Connection data         
    MQTTPacket_connectData dataMQTT = MQTTPacket_connectData_initializer;       
    dataMQTT.MQTTVersion = 3;
    dataMQTT.clientID.cstring = clientID;
    dataMQTT.username.cstring = username;
    dataMQTT.password.cstring = password;
    

    // client connection
    if ((rc = clientMQTT.connect(dataMQTT)) != 0)
    {
        printf("rc from MQTT connect is %d\n", rc);
    }else
    {
        printf("MQTT connection OK\n");
        led2 = 1;
    }
    
    
    // topic subscribe
    if ((rc = clientMQTT.subscribe(topic, MQTT::QOS2, messageArrived)) != 0)
    {
        printf("rc from MQTT subscribe is %d\n", rc);
    }else
    {
        printf("MQTT subscribe OK\n");
    } 
    
    
    // QoS 0
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;



    // Set configuration register
    TempSensor.write_reg(0x01, 0x00);
    fTemperatureTemp = TempSensor.read_T();

    bStart = true;

    while(1) 
    {

        if(bNewValue)
        {
            bNewValue = false;
            message.payload = (void*)bufMQTT;
            message.payloadlen = strlen(bufMQTT)+1;
            
            // publish message
            rc = clientMQTT.publish(topic, message);
        }
         
      
        clientMQTT.yield(100);     
    }
}
