#pragma once 
#include "mbed.h"

#define MQTTCLIENT_QOS2 1

#include "MQTTEthernet.h"
#include "MQTTClient.h"
#include "LM75A.h"


RawSerial pc(USBTX,USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// I2C
LM75A TempSensor(p28, p27, 0x90);    //SDA, SCL, ADDRESS



MQTT::Message message;


bool bNewValue = false;
bool bStart = false;
volatile int i = 0;
int rc;
char bufMQTT[100];
float fTemperature = 0;
float fTemperatureTemp = 0;
  

// MQTT Data
char* clientID = "mqtt-mbed-test";
char* hostbroker = "m10.cloudmqtt.com";
int port = 18305;
char* username = "mbedUser";
char* password = "test";
char* topic = "temperature";


//THREAD
void temp_sensor_thread(void const *argument);
osThreadDef(temp_sensor_thread, osPriorityNormal, DEFAULT_STACK_SIZE); 


