#ifdef TARGET_LPC4330_M4
#include "MODSERIAL.h"


void MODSERIAL::setBase(void ) {
switch( _serial.index ) {
        case 0: _base = LPC_USART0; _IRQ = USART0_IRQn; break;
        case 1: _base = LPC_UART1; _IRQ = UART1_IRQn; break;
        case 2: _base = LPC_USART2; _IRQ = USART2_IRQn; break;
        case 3: _base = LPC_USART3; _IRQ = USART3_IRQn; break;
        default: _base = NULL; _IRQ = (IRQn_Type)NULL; break;
    }
}

void MODSERIAL::initDevice(void) {
    ((LPC_USART_T*)_base)->FCR = (1UL<<0) + (1UL<<1) + (1UL<<2);
    }

bool MODSERIAL::txIsBusy( void ) 
{ 
    return ( (((LPC_USART_T*)_base)->LSR & ( 1UL << 6 )) == 0 ) ? true : false; 
} 

#endif
