/*
 * Author: Edoardo De Marchi
 * Date: 19-08-2014
 * Notes: Test code for MCP9700A Temperature Sensor
*/

#include "mbed.h"

Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);
AnalogIn temp(p15);


float TempRead()
{
    float Ta = 0.0;

    float t = temp.read();           //Read the input voltage
    Ta = ((t * 3.3) - 0.5)/ 0.01;      
    
    return Ta;                      // return the temp
}


int main() 
{
    pc.baud(115200);
    
    while(1) 
    {
        pc.printf("The Temp is: %2.2f deg C\n\r", TempRead());
        myled = !myled;
         
        wait(2);   
    }
}