/*
 * Author: Edoardo De Marchi
 * Date: 15-08-2014
 * Notes: Test code for LM75AIM
*/

#include "mbed.h"
#include "LM75A.h"


Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);

#if   defined(TARGET_LPC1768)
LM75A Temp(p28, p27, 0x90);    //SDA, SCL, ADDRESS
#elif defined(TARGET_LPC4330_M4)
LM75A Temp(I2C1_SDA, I2C1_SCL, 0x90);      //sda, scl, Addr
#endif




int main()
{ 
    #if   defined(TARGET_LPC1768)
    char* board = "LPC1768";
    #elif defined(TARGET_LPC4330_M4)
    char* board = "LPC4330";
    #endif
    
    pc.baud(115200);
    pc.printf("BOARD %s\r\n", board);
    
    Temp.write_reg(0x01, 0x00);
  
    while(1)
    {
        pc.printf("The temp is: %4.2f degree Celsius\n\r", Temp.read_T());
        led1 = !led1;       
        wait(2);
    }         
}
