/* Author: Edoardo De Marchi */
/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */




#pragma once 
 
#include "mbed.h"
 
 
#define TEMP_REG_ADDR 0x00          // Temperature address
 
 
/* Library for the LM75A temperature sensor.
The LM75A is an I2C digital temperature sensor in a small SOP-8 package, 
with a 0.5C resolution and 2C accuracy
*/
 
class LM75A{        // Creates an instance of the class
    public:
        
           /** Create an LM75A object connected to the specified I2C object and using the specified deviceAddress
            *
            * @param sda The I2C port data
            * @param scl The I2C port clock
            * @param addr The address of the MMA7660FC
            */
      LM75A(PinName sda, PinName scl, int addr);
    
    
            /** Destroys an LM75A object
            *
            */
      ~LM75A();
    
            /** Reads the current temperature
            *
            * @param returns Return the Temperature value 
            */
      float read_T();
      
            /** Reads from specified LM75A register
            *
            * @param addr Pointer register
            * @param returns Return the data from the register 
            */
      char read_reg(char addr);
      
            /** Writes to specified LM75A register
            *
            * @param addr Pointer register
            * @param data Data to write
            */ 
      void write_reg(char addr, char data);
      
    
    private:
      I2C m_i2c;
      int m_addr;   
      char reg_addr;
};
 
