/* Author: Edoardo De Marchi */
/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */




#include "LM75A.h"



LM75A::LM75A(PinName sda, PinName scl, int addr) : m_i2c(sda, scl), m_addr(addr)
{
    reg_addr =  TEMP_REG_ADDR;
}


LM75A::~LM75A()
{

}



float LM75A::read_T()
{

  m_i2c.write(m_addr, &reg_addr, 1);                // Pointer to the temperature register
  char cmd[2] = {0,0};
  m_i2c.read(m_addr, cmd, 2);                           // read temperature register
  
  unsigned short val = ((cmd[0] << 8) + cmd[1]) >> 7;     //val = (cmd[ 1 ] << 1) | ( cmd[ 0 ] >> 7 ) ;
   
  float temp = (float) ((float)val * 0.5);  
  
  return temp;
}



char LM75A::read_reg(char addr)
{

    char data[1] = {0};
    char tmp = addr;
    m_i2c.write(m_addr, &tmp, 1);           
    m_i2c.read(m_addr, data, 1);              // Read register content
    
    return data[0];

}



void LM75A::write_reg(char addr, char data)
{

    char data2[2] = {0, 0};
    
    data2[0] = addr;
    data2[1] = data;
    
    m_i2c.write(m_addr, data2, 2);             

}

