/*
 * Author: Edoardo De Marchi
 * Date: 22-08-14
 * Notes: Firmware for GPS U-Blox NEO-6M
*/

#include "main.h"


void Init()
{
    gps.baud(9600);
    pc.baud(115200);

    pc.printf("Init OK\n");
}



int main() 
{   
    Init();
    char c;

    while(true) 
    {
        if(gps.readable())
        { 
            if(gps.getc() == '$');           // wait a $
            {
                for(int i=0; i<sizeof(cDataBuffer); i++)
                {
                    c = gps.getc();
                    if( c == '\r' )
                    {
                        //pc.printf("%s\n", cDataBuffer);
                        parse(cDataBuffer, i);
                        i = sizeof(cDataBuffer);
                    }
                    else
                    {
                        cDataBuffer[i] = c;
                    }                 
                }
            }
         } 
    }
}


void parse(char *cmd, int n)
{
    
    char ns, ew, tf, status;
    int fq, nst, fix, date;                                     // fix quality, Number of satellites being tracked, 3D fix
    float latitude, longitude, timefix, speed, altitude;
    
    
    // Global Positioning System Fix Data
    if(strncmp(cmd,"$GPGGA", 6) == 0) 
    {
        sscanf(cmd, "$GPGGA,%f,%f,%c,%f,%c,%d,%d,%*f,%f", &timefix, &latitude, &ns, &longitude, &ew, &fq, &nst, &altitude);
        pc.printf("GPGGA Fix taken at: %f, Latitude: %f %c, Longitude: %f %c, Fix quality: %d, Number of sat: %d, Altitude: %f M\n", timefix, latitude, ns, longitude, ew, fq, nst, altitude);
    }
    
    // Satellite status
    if(strncmp(cmd,"$GPGSA", 6) == 0) 
    {
        sscanf(cmd, "$GPGSA,%c,%d,%d", &tf, &fix, &nst);
        pc.printf("GPGSA Type fix: %c, 3D fix: %d, number of sat: %d\r\n", tf, fix, nst);
    }
    
    // Geographic position, Latitude and Longitude
    if(strncmp(cmd,"$GPGLL", 6) == 0) 
    {
        sscanf(cmd, "$GPGLL,%f,%c,%f,%c,%f", &latitude, &ns, &longitude, &ew, &timefix);
        pc.printf("GPGLL Latitude: %f %c, Longitude: %f %c, Fix taken at: %f\n", latitude, ns, longitude, ew, timefix);
    }
    
    // Geographic position, Latitude and Longitude
    if(strncmp(cmd,"$GPRMC", 6) == 0) 
    {
        sscanf(cmd, "$GPRMC,%f,%c,%f,%c,%f,%c,%f,,%d", &timefix, &status, &latitude, &ns, &longitude, &ew, &speed, &date);
        pc.printf("GPRMC Fix taken at: %f, Status: %c, Latitude: %f %c, Longitude: %f %c, Speed: %f, Date: %d\n", timefix, status, latitude, ns, longitude, ew, speed, date);
    }
}




