/*
 * Author: Edoardo De Marchi
 * Date: 15/02/14
 * Notes: Checks the Ethernet cable connection
*/


#include "mbed.h"
#include "EthernetInterface.h"
#include "eth_status.h"

DigitalOut led1(LED1);          
DigitalOut led2(LED2);          
DigitalOut led3(LED3);          
DigitalOut led4(LED4);   

       
//ETHERNET
#define ECHO_SERVER_PORT   2000

char* ip = "192.168.153.153";               // ip
char* mask = "255.255.255.0";               // mask
char* gateway = "192.168.153.100";          // gateway
EthernetInterface eth;
TCPSocketConnection client;
TCPSocketServer server; 


int Init()
{
    led1 = 0;               
    led2 = 0;               
    led3 = 0;               
    led4 = 0;               
    
       
    // ETHERNET
    eth.init(ip, mask, gateway);
    eth.connect();
    server.bind(ECHO_SERVER_PORT);
    server.listen(1);
    printf("IP Address is %s\r\n", eth.getIPAddress());    
    printf("%s  - Speed: %d Mbps\n", get_transmission_status(), get_connection_speed());
             
    return 0;
}



int main() 
{
    bool eth_status = false;
    bool eth_status_temp = true;
    
    Init();
    
    
    while(true) 
    {
        printf("\nWait for new connection...\n");
        server.accept(client);
        
        printf("Connection from: %s\n", client.get_address());

        while (true)
        {          
            if(!get_link_status())
            {
                eth_status = true; 
            }else
            {
                eth_status = false;
                eth_status_temp = true;
                led1 = 0;                           
            }
            
            if(eth_status == eth_status_temp)
            {
                eth_status_temp = !eth_status;
                printf("Check cable connection\r\n");
                led1 = 1;
                eth_status = false;
            }
            led2 = !led2; 
            osDelay(500);
        }          
    }
}
