/*
 * Author: Edoardo De Marchi
 * Date: 19-03-13
 * Notes: Test MLDP connection with Microchip RN4020 BLE
*/


#include "main.h"


// Send command to ble
void send_cmd(char* cmd) 
{
    ble_rn.printf("%s\r", cmd); 
}

 
// init ble
void setup_ble() 
{
    // Set the WAKE_SW pin high to enter Command mode.
    wakeSw = 1; 
    wakeHw = 0;
    
    // enable Command Mode
    cmdMldp = 0;                        // (0 --> CMD, 1 --> MLDP)


    // reset to the factory default configuration
    send_cmd("SF,1");
    osDelay(500);                 
    pc.printf("SF,1\n");


    // sets the services supported
    send_cmd("SS,00000000");          // No Service
    osDelay(500);
    send_cmd("GS");
    
    
    // sets the supported features of current RN4020 module
    // Auto Advertise 
    // Enable MLDP
    // UART Flow Control
    // Auto-enter MLDP Mode
    send_cmd("SR,32000A00");                                              
    osDelay(500);
    send_cmd("GR");
   
    
    // sets the device name
    send_cmd("SN,RN4020");           
    osDelay(500);
    send_cmd("GN");
       
    
    // reboot the RN4020 module and to make the new settings effective
    send_cmd("R,1"); 
    osDelay(500);                 
    pc.printf("R,1\n");
    
    
    osDelay(2000);               
     
    start_ble = true;   
    cmdMldp = 1; 
} 
 


// This function is called when a character goes into the RX buffer.
void rxBleCallback(MODSERIAL_IRQ_INFO *q) 
{
    led2 = 1;
    new_from_ble = true;
}

// This function is called when a character goes into the RX buffer.
void rxPcCallback(MODSERIAL_IRQ_INFO *q) 
{
    led3 = 1;
    new_from_pc = true;
} 



// read from BLE
void read_thread(void const *argument)
{
    while (true) 
    {
        if(new_from_ble)
        {
            memset(blueChar, 0, sizeof(blueChar)); 
            
            int i = 0;
            while(ble_rn.readable())
            {
                blueChar[i] = ble_rn.getc();           
                i++;        
            }
            if(i > 0)
            {
                pc.printf("%s", blueChar);
                new_from_ble = false;  
            } 
            
            led2 = 0;
        }  
    } 
} 




int main() 
{   

    ble_rn.baud(115200);
    pc.baud(115200);
    
    ble_rn.attach(&rxBleCallback);
    pc.attach(&rxPcCallback);
 
    osThreadCreate(osThread(read_thread), NULL);
    
    pc.printf("Bluetooth Start\r\n");
    
    // Init device
    setup_ble();
 
    
    int iBlink = 0;
   
    while(1)
    {
        if(new_from_pc)
        {
            // receive from PC uart
            int iCount = 0;
            while(pc.readable())
            {
                pcChar[iCount] = pc.getc();
                iCount++;
            }
            
            // send to ble
            send_cmd(pcChar);
            memset(pcChar, 0, sizeof(pcChar));
            new_from_pc = false;
            led3 = 0;
        } 
        osDelay(10);
        iBlink++;
        if(iBlink == 50)
        {
            led1 = !led1;
            iBlink=0;    
        }
    } 
}