/* Author: Edoardo De Marchi 
 * Note: Firmware for the software 3D Accelerometer Tester v1.1
 */
 
#include "main.h"


void INTSU()
{
    led4 = !led4;
    bCheckINT = true;
}

void rxCallback(MODSERIAL_IRQ_INFO *q) 
{
     new_send = true;
}


int main() 
{
    
    pc.baud(921600);
    
    pc.attach(&rxCallback, MODSERIAL::RxIrq);
    INT.rise(&INTSU);
    
    MMA.init();    // Initialization 
    
    led1 = 1;
    led4 = 0;
           
    while(1)
    {    
        if(new_send)
        {
            int i = 0;
       
            while(pc.readable())
            {
                word[i] = pc.getc();
                i++;
            }
            parse_cmd(); 
        }else
        if(bCheckINT)
        {            
            if((MMA.read_reg(0x03) & 0x80) != 0)
            {
                pc.printf("SHAKE");
            }else
            if((MMA.read_reg(0x03) & 0x20) != 0)
            {
                pc.printf("TAPE");
            }else    
            {
                strcpy(word,"read_data");
                parse_cmd();
            }  
            bCheckINT = false;
        }    
        MMA.read_reg(0x00);       
        wait_ms(50);
        
           
    }
}



void parse_cmd(){
            new_send = false;
           
            if(strcmp("reset", word) == 0)              
            {
                    mbed_reset();        
            }else
            if(strcmp("read_data", word) == 0)              
            {
                    pc.printf("x: %2d", MMA.read_x()+10);          // Print the X axis acceleration
                    pc.printf("y: %2d", MMA.read_y()+10);          // Print the Y axis acceleration
                    pc.printf("z: %2d", MMA.read_z()+10);          // Print the Z axis acceleration      
            }else
            if(strncmp("w_reg", word, 5) == 0)                 
            {        
                    int reg_addr = 0;                
                    int reg_value = 0;
                    char temp[3];
                    strncpy(temp, &word[5], 3);  
                    reg_addr = atoi(temp);
                    memset(temp, 0, sizeof(temp));
                    strncpy(temp, &word[8], 3); 
                    reg_value = atoi(temp);                     
                    MMA.write_reg(reg_addr, reg_value);
                    
                    memset(temp, 0, sizeof(temp));
                    memset(word, 0, sizeof(word));
            }else
            if(strncmp("r_reg", word, 5) == 0)                 
            {       
            
                    int reg_value = 0;
                    char temp[3];
                    strncpy(temp, &word[5], 3);  
                    reg_value = atoi(temp);   
                    pc.printf("%x", MMA.read_reg(reg_value));  
                    
                    memset(temp, 0, sizeof(temp));              
                    memset(word, 0, sizeof(word));
            }           
            memset(word, 0, sizeof(word));            
}

