
#ifndef IR_sensors_H
#define IR_sensors_H
 
#include "mbed.h"
enum State {left = 0b100, 
            centerleft = 0b110, 
            center = 0b010, 
            centerright = 0b011, 
            right= 0b001,
            undef0 = 0b000,
            undef1 = 0b111,
            undefx = 0b101
            };
            
class IR_sensors {
    public:
        IR_sensors( 
            PinName pinleft, 
            PinName pincenter, 
            PinName pinright,
            PinName ledleft,
            PinName ledcenter,
            PinName ledright
        );
        
        State state(void);
    protected:       
        DigitalIn   _pinleft;
        DigitalIn   _pincenter;
        DigitalIn   _pinright;
        DigitalOut  _ledleft;
        DigitalOut  _ledcenter;
        DigitalOut  _ledright;
        State _state;
        
 
};


#endif
