
#include "mbed.h"
#include "IR_sensors.h"
IR_sensors::IR_sensors(
                    PinName pinleft, 
                    PinName pincenter, 
                    PinName pinright,
                    PinName ledleft,
                    PinName ledcenter,
                    PinName ledright
    ):
    _pinleft(pinleft), _pincenter(pincenter), _pinright(pinright),
    _ledleft(ledleft), _ledcenter(ledcenter), _ledright(ledright)
    {
        _state = undef1;  
}


State IR_sensors::state(){
    State ans = undef0;
    if(!_pinleft & !_pincenter & !_pinright & (ans == undef0))
    {
        _ledleft = 1;
        _ledcenter = 1;
        _ledright = 1;
        ans = undef1;
    }
    if(!_pinleft & !_pincenter & _pinright & (ans == undef0))
    {
        _ledleft = 1;
        _ledcenter = 1;
        _ledright = 0;
        ans = centerleft;
    }
    if(!_pinleft & _pincenter & !_pinright & (ans == undef0))
    {
        _ledleft = 1;
        _ledcenter = 0;
        _ledright = 1;
        ans = undefx;
    }
    if(!_pinleft & _pincenter & _pinright & (ans == undef0))
    {
        _ledleft = 1;
        _ledcenter = 0;
        _ledright = 0;
        ans = left;
    }
    if(_pinleft & !_pincenter & !_pinright & (ans == undef0))
    {
        _ledleft = 0;
        _ledcenter = 1;
        _ledright = 1;
        ans = centerright;
    }
    if(_pinleft & !_pincenter & _pinright & (ans == undef0))
    {
        _ledleft = 0;
        _ledcenter = 1;
        _ledright = 0;
        ans = center;
    }
    if(_pinleft & _pincenter & !_pinright & (ans == undef0))
    {
        _ledleft = 0;
        _ledcenter = 0;
        _ledright = 1;
        ans = right;
    }
    if(_pinleft & _pincenter & _pinright & (ans == undef0))
    {
        _ledleft = 0;
        _ledcenter = 0;
        _ledright = 0;
        ans = undef0;
    }
    return ans;
    }