
#ifndef MBED_MOTOR_H
#define MBED_MOTOR_H
 
#include "mbed.h"
#include <Motor.h>    // DC motor driver 

struct Car_vector {
            float speed;
            float turnCW;
            };


class Car {
    public:
        Car(    PinName pwm1, 
                PinName fwd1, 
                PinName rev1,
                PinName pwm2, 
                PinName fwd2, 
                PinName rev2
        );
        
        //Sets the speed as a percentage (i.e. 1 = 100% and 0.5 = 50%)
        void speed(float speed);
        float speed(void);
        
        //Sets the speed difference between the motors
        // Example 1: if original speed is 50%
        // turnCW(0.5) => rightMotor @ 25% and leftMotor @ 75%
        // turnCW(0.1) => rightMotor @ 45% and leftMotor @ 55%
        //
        // Example 2: if original speed is 100%
        // turnCW(0.5) => rightMotor @ 75% and leftMotor @ 100%
        // turnCW(0.1) => rightMotor @ 95% and leftMotor @ 100%
        void turnCW(float turn);
           
    protected:
        void    _set_motors(void);
        float   _clamp_speed(float sp);
        void    _mlspeed(float sp);
        void    _mrspeed(float sp);
        
        
        float _car_speed;
        float _car_turn;
        PwmOut  _ml_pwm;
        PwmOut  _mr_pwm;
        DigitalOut _ml_fwd;
        DigitalOut _mr_fwd;
        DigitalOut _ml_rev;
        DigitalOut _mr_rev;
 
};


#endif
