#include "mbed.h"
#include "Car.h"    // DC motor driver

Car::Car( PinName pwmr, 
          PinName fwdr, 
          PinName revr,
          PinName pwml, 
          PinName fwdl,
          PinName revl
    ):
    _mr_pwm(pwmr), _mr_fwd(fwdr), _mr_rev(revr),
    _ml_pwm(pwml), _ml_fwd(fwdl), _ml_rev(revl)
    {
        _car_speed = 0.0;
        _car_turn = 0.0;
        // Set initial condition of PWM
        _ml_pwm.period(0.001);
        _mr_pwm.period(0.001);
        _ml_pwm = 0;
        _mr_pwm = 0;

        // Initial condition of output enables
        _ml_fwd = 0;
        _mr_fwd = 0;
        _ml_rev = 0;
        _mr_rev = 0;
    }

void Car::_mlspeed(float sp){
    _ml_fwd = (sp > 0.0);
    _ml_rev = (sp < 0.0);
    _ml_pwm = abs(sp);
}

void Car::_mrspeed(float sp){
    _mr_fwd = (sp > 0.0);
    _mr_rev = (sp < 0.0);
    _mr_pwm = abs(sp);
}

void Car::speed(float sp){
    _car_speed = sp;
    Car::_set_motors();
}

float Car::speed(void){
    return _car_speed;
}

void Car::turnCW(float turn){
    _car_turn = turn;
    Car::_set_motors();
}
        
void Car::_set_motors(void){
    //float speedleft = _car_speed * (1.0 + _car_turn);  //Ideal way to do it
    //float speedright = _car_speed * (1.0 - _car_turn);
    float speedleft = _car_speed;
    float speedright = _car_speed;
    bool turning = (abs(_car_turn) > 0.0) and (abs(_car_speed) > 0.0);
    if (turning){
            if (_car_turn > 0.0) {
                speedleft = _car_turn;
                speedright = 0.0;
            }
            if (_car_turn < 0.0) {
                speedleft = 0.0;
                speedright = -_car_turn;
            }
    }
    _mlspeed(_clamp_speed(speedleft));
    _mrspeed(_clamp_speed(speedright));
}

float Car::_clamp_speed(float sp){
    float temp;
    if (abs(sp) <= 1.0)
        temp = sp;
    else
        if (sp > 1.0)
            temp = 1.0;
        else
            temp = -1.0;
    return temp;
}
