#include "mbed.h"
#include "TextLCD.h"
#include "HCSR04.h"// Biblioteca del sensor ultrasonico

Serial pc(PA_2,PA_3);
I2C i2c_lcd(PB_7, PB_8); // SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD20x4);

//DigitalOut led(LED1, 0);                    // Create the LED object and setup OFF
Timeout timeout;                            // Create the Timeout object

Timer t; //declaracion de contador
AnalogIn sensor(PB_0);               //entrada analogica para sensor de temperatura
HCSR04 sensord(PB_4,PB_5);            //Declaración del sensor ultrasonico y de los puertos de entrada a trigger y echo
DigitalOut myled (PD_14);
DigitalOut myled2 (PD_13);
float value; //variable para datos de temparatura
float volt; //variable para datos de voltaje
int d;

int main()     //Rutina Principal
{
    
value = (((sensor.read()*5000)/10)-22); // calculo para prsentar tempertura
volt = (value*10);// calculo para presentar voltaje de sensor

lcd.cls();
lcd.setBacklight(TextLCD::LightOn);
lcd.setCursor(TextLCD::CurOff_BlkOff);
          pc.baud(115200); //    Velocidad de Transmisión

        while(1) {  // inicio de bucle,Condicional establecido para que siempre sea verdadero
        
                    
            int d= sensord.distance(1); // comando para un numero largo de bits
            if (d<20) { //condicional de led
                myled=1;
                myled2=0;
                
                t.start(); // inicio de contador
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf ("Temp= %2.2f C, ", value);  //escribir dato de temperatura
                lcd.locate(0,1);
                lcd.printf ("volt= %2.2f mv, ", volt); //escribir dato de voltaje sensor
                lcd.locate(0,2);
                lcd.printf ("D= %d cm, ",d); // comando de impresion para mostra
                lcd.locate(0,3);
                lcd.printf ("time= %d ms, \r\n", t.read_ms()); // escribir datos de tiempo de lectura
                t.stop(); //pausa de contador

                wait (1);
                } 
                
                else if (d>=20) {
                myled=0;
                myled2=1;
                lcd.cls();
                lcd.locate(6,1);
                lcd.printf ("D= %d cm, ",d); // comando de impresion para mostra
                lcd.locate(3,2);
                lcd.printf ("Fuera de rango"); //
                wait (1);
            }
           
   
}

}



