#include "mbed.h"
#include "HCSR04.h"// Biblioteca del sensor ultrasonico

Timer t; //declaracion de contador
AnalogIn sensor(PB_0);               //entrada analogica para sensor de temperatura
HCSR04 sensord(PB_6,PB_7);            //Declaración del sensor ultrasonico y de los puertos de entrada a trigger y echo
Serial device(PA_2,PA_3);             //comunicacion seria
DigitalOut myled (PD_14);
DigitalOut myled2 (PD_13);

float value; //variable para datos de temparatura
float volt; //variable para datos de voltaje


int main() {   //Declaración de la función principal
    device.baud(115200); 
    //device.printf("Start\n");
    
    while(1) {  // inicio de bucle,Condicional establecido para que siempre sea verdadero
    int d= sensord.distance(1); // comando para un numero largo de bits
    if (d<20) { //condicional de led
    myled=1;
    myled2=0;
    }
    else if (d>=20){
    myled=0;
    myled2=1;
    }
  
     value = (((sensor.read()*5000)/10)-20); // calculo para prsentar tempertura
     volt = (value*10);// calculo para presentar voltaje de sensor
     
     t.start(); // inicio de contador  
    
     device.printf ("Temp= %2.2f C, ", value);  //escribir dato de temperatura
     device.printf ("volt= %2.2f mv, ", volt); //escribir dato de voltaje sensor
     device.printf ("D= %d cm, ",d); // comando de impresion para mostra
     device.printf ("time= %d ms, \r\n", t.read_ms()); // escribir datos de tiempo de lectura
     t.stop(); //pausa de contador
     
     wait (2);
    
     }
}
