/*******************************************************************************************
 *
 * University of York Robot Lab Pi Swarm Robot Library
 *
 * (C) Dr James Hilder, Dept. Electronics & Computer Science, University of York
 * 
 * Version 0.6  February 2014
 *
 * Designed for use with the Pi Swarm Board (enhanced MBED sensor board) v1.2
 *
 ******************************************************************************************/

#ifndef MAIN_H
#define MAIN_H

#include "piswarm.h"

void handleUserRFCommand(char * data, char length);
void handleUserRFCommand(char sender, char broadcast_message, char request_response, char id, char is_command, char function, char * data, char length);
void handleUserRFResponse(char sender, char broadcast_message, char request_response, char id, char is_command, char function, char * data, char length);
void processRawRFData(char * rstring, char cCount);
void switch_pressed ( void );

//This function collects all outer IR sensors information and store them in an array.
void get_sensors_values( void );
//Detect strongest source of IR and face towards it. Cosntant defines rate of spin.
void attraction( float direction_constant );
//Do flocking behaviour
void flocking( void );
//Do aggregation behaviour
void aggregation( void );

#endif //MAIN_H