 #include "Lora.h"
 //#include "OBD.h"
 #include "Common_Defs.h"
 //#include "Beacon.h"
 
 //Configure Lora Packet
 RawSerial LORA_Module_UART(PA_0, PA_1);//USART4_TX->PA_0,USART4_RX->PA_1
 RawSerial pc2(PA_14, PA_15);//USART1_TX->PA_9,USART1_RX->PA_10
 Serial pc_2(USBTX, USBRX);

 uint8 Packet_Type_To_Send = HEARTBEAT_TYPE_PACKET;  //By Default Heart Beat PAckets should be sent
 uint8 OBD_Protocol_Version = 0x01;
 uint8 Vehicle_Identification_Number[17];                     //Unique Vehicle_Identification_Number, Read using OBD
 uint8 Motion_Packet_Sent_Count=0;
 uint8 CheckIN_Packet_Sent_Count=0;
 uint8 Lora_Packet_To_Send[100];
 uint8 Send_Lora_Packet_Flag = FALSE;
 int Lora_RxBuffer_Crnt_Pos,Lora_RxBuffer_End_Pos; // must be volatile or the compiler may over-optimise.
 int receivedDataCount = 0;
 char LORA_UART_RX_Buffer[LORA_UART_RX_Size];
 int LORA_UART_RX_Crnt_Pos;
 uint8 Lora_Command_Rcvd[100];
 uint8 Lora_Cmd_Length = 0;
 uint8 AT_Response_Receive_Status = FAILURE; 
 
 //Create Object for Type of Lora Packet to send
 Heart_Beat_PacketType Heart_Beat_Lora_Packet;    //Allocate Memory for HeartBeat Lora Packets
 CheckIN_PacketType CheckIN_Lora_Packet; //Allocate Memory for CheckIN Lora Packets
 CheckOUT_PacketType CheckOUT_Packet; //Allocate Memory for CheckOUT Lora Packets
 Motion_PacketType Motion_Lora_Packet;    //Allocate Memory for Movement Lora Packets
 Vehicle_Status_PacketType Vehicle_Status_Lora_Packet;    //Allocate Memory for Movement Lora Packets
 Near_Car_Beacon Near_Car_Beacon_Packet;
 Fixed_Beacon Fixed_Beacon_Packet;
 Misc_Packets Misc_Packet_Data;
    
 //Lora AT Commands list
 const char* Attention = {"AT\r"};     
 const char* Reset_Device = "ATZ\r";
 const char* Reset_to_Factory_Defaults = "AT&F\r";
 const char* Save_Configuration = "AT&W\r";
 const char* Serial_Baud_Rate = "AT+IPR=";
 const char* Join_Network = "AT+JOIN\r";
 const char* Join_Retries = "AT+JR=";
 const char* AES_Encryption = "AT+ENC=";
 const char* Send_Lora_Packet = "AT+SEND ";
 const char* Set_Frequency_Sub_Band = "AT+FSB=";
 const char* Set_Network_ID = "AT+NI=";
 const char* Set_Network_Key = "AT+NK=";
 const char* Network_Key = "010203123";
 const char* Network_ID = "010203040";
 const char* Network_Join_Retries = "AT+JR=";
 const char* Network_Join_Status = "AT+NJS=";
 const char* Lora_Device_ID = "AT+DI\r";
 
 #define CHECK_IN_PACKET        0x00
 #define CHECK_OUT_PACKET       0x01

 uint8 Calculate_Lora_Frame_FCS(uint8* Packet_Data,uint8 Packet_Length);
 void Set_Up_Lora_Network_Configuration(void); 
 void Get_Lora_Response(void);
 
//Set Up lora network
void Set_Up_Lora_Network_Configuration(void)
{
    pc_2.baud(115200);
    LORA_Module_UART.baud(115200);
    LORA_Module_UART.printf(Attention);//Send Attention command
    AT_Response_Receive_Status = FAILURE;
    pc2.printf("\nNwk set up started");
    while(AT_Response_Receive_Status)
        Get_Lora_Response();
    pc2.printf("\nAT Response received");
    LORA_Module_UART.printf("%s%d\r",Set_Frequency_Sub_Band,FREQUENCY_SUB_BAND_CHANNEL7);//set frequency sub band to 7
    AT_Response_Receive_Status = FAILURE;
    while(AT_Response_Receive_Status)
        Get_Lora_Response();
    pc2.printf("\nFrequency band response received");
    LORA_Module_UART.printf("\n%s%d,%s\r",Set_Network_Key,STRING_PARAMETER,Network_Key);   //set network key
    AT_Response_Receive_Status = FAILURE;
    while(AT_Response_Receive_Status)
        Get_Lora_Response();
    pc2.printf("\nNetwork key Response received");
    LORA_Module_UART.printf("\n%s%d,%s\r",Set_Network_ID,STRING_PARAMETER,Network_ID);     //set network id
    AT_Response_Receive_Status = FAILURE;
    while(AT_Response_Receive_Status)
        Get_Lora_Response();
    pc2.printf("\nNetwork Id response received");
    
    LORA_Module_UART.printf("AT+TXDR=DR3\r");
    AT_Response_Receive_Status = FAILURE;
    while(AT_Response_Receive_Status)
        Get_Lora_Response();
    LORA_Module_UART.printf("AT+RXDR=10\r");
    AT_Response_Receive_Status = FAILURE;
    while(AT_Response_Receive_Status)
        Get_Lora_Response();
    LORA_Module_UART.printf("AT+ADR=0\r"); //Enable adaptive data rate
    AT_Response_Receive_Status = FAILURE;
    while(AT_Response_Receive_Status)
        Get_Lora_Response();
    LORA_Module_UART.printf("%s",Save_Configuration);              //save configuration          
    AT_Response_Receive_Status = FAILURE;
    while(AT_Response_Receive_Status)
        Get_Lora_Response();
    
    pc2.printf("\nConfiguration saved");
    LORA_Module_UART.printf("%s",Reset_Device);                    //reset device
    wait_ms(3500);
    LORA_Module_UART.printf(Attention);        //Send Attention command
    AT_Response_Receive_Status = FAILURE;
    while(AT_Response_Receive_Status)
        Get_Lora_Response();
    pc2.printf("\nAT Response received");
    LORA_Module_UART.printf("%s",Join_Network);                    //join network with gateway
    AT_Response_Receive_Status = FAILURE;
    while(AT_Response_Receive_Status)
        Get_Lora_Response();
    pc2.printf("\nJoin Response received");
}

 void Initialize_lora_Packets()
{
    uint8 i;
    /******* Initialize Lora packet for HeartBeat *****/
    Misc_Packet_Data.Header = LORA_PACKET_HEADER;
    Misc_Packet_Data.Protocol_Version = OBD_Protocol_Version;
    Heart_Beat_Lora_Packet.Packet_Type = HEART_BEAT_PACKET_CMD;
    Misc_Packet_Data.OBD_Battery_Voltage = 350;       //3.50V, dummy data
    Misc_Packet_Data.Car_Battery_Voltage = 1250;      //12.50V, dummy data
    Misc_Packet_Data.OBD_Battery_Temperature = 95;    //95'F, dummy data
    Misc_Packet_Data.Car_Ambient_Temperature = 104;   //104'F, dummy data
    for(i=0;i<6;i++)
        Fixed_Beacon_Packet.Parking1_Beacon_ID[i] = (0x01+i);      //MAC ID of 1st NearBy Beacon Device with Highest Signal Strength,dummy data
    Fixed_Beacon_Packet.Parking1_Beacon_Signal_Strength = 23;             //Signal Strength of 3rd NearBy Beacon Device with Highest Signal Strength          
    for(i=0;i<6;i++)
        Fixed_Beacon_Packet.Parking2_Beacon_ID[i] = (2+i);      //MAC ID of 1st NearBy Beacon Device with Highest Signal Strength,dummy data
    Fixed_Beacon_Packet.Parking2_Beacon_Signal_Strength = 45;             //Signal Strength of 3rd NearBy Beacon Device with Highest Signal Strength          
    for(i=0;i<6;i++)
        Fixed_Beacon_Packet.Parking3_Beacon_ID[i] = (3+i);      //MAC ID of 1st NearBy Beacon Device with Highest Signal Strength,dummy data
    Fixed_Beacon_Packet.Parking3_Beacon_Signal_Strength = 12;             //Signal Strength of 3rd NearBy Beacon Device with Highest Signal Strength    
    Heart_Beat_Lora_Packet.Sequence_No = 0x01;                   //Sent Packet Sequence Number
    Heart_Beat_Lora_Packet.FCS = 0x00;                                 //FCS of all packets        
    
    /******* Initialize Lora packet for Vehicle Status *****/
    Misc_Packet_Data.Header = LORA_PACKET_HEADER;
    Misc_Packet_Data.Protocol_Version = OBD_Protocol_Version;
    Vehicle_Status_Lora_Packet.Packet_Type = STATUS_PACKET_CMD;
    for(i=0;i<17;i++)
        Misc_Packet_Data.VIN[i] = 0x06;//Vehicle_Identification_Number[i];
    for(i=0;i<3;i++)
        Misc_Packet_Data.ODO_METER_READING[i] = 0x05;  //Dummyy data, To be read using OBD
    Vehicle_Status_Lora_Packet.Fuel_Level = 1050;//10.5 litre
    Misc_Packet_Data.OBD_Battery_Voltage = 200;
    Misc_Packet_Data.Car_Battery_Voltage = 1000;
    Misc_Packet_Data.OBD_Battery_Temperature = 100;
    Misc_Packet_Data.Car_Ambient_Temperature = 200;
    for(i=0;i<6;i++)
        Vehicle_Status_Lora_Packet.BLE_Adv_Beacon_ID[i] = 0x01;//BLE_Adv_Module_Beacon_ID[i];         //MAC ID of 1st NearBy Beacon Device with Highest Signal Strength,dummy data
    for(i=0;i<6;i++)
        Near_Car_Beacon_Packet.Near_Car1_Beacon_ID[i] = (3+i);         //MAC ID of 1st NearBy Beacon Device with Highest Signal Strength,dummy data
    Near_Car_Beacon_Packet.Near_Car1_Beacon_Signal_Strength = 0x07;   //Signal Strength of 3rd NearBy Beacon Device with Highest Signal Strength          
    for(i=0;i<6;i++)
        Near_Car_Beacon_Packet.Near_Car2_Beacon_ID[i] = (2+i);         //MAC ID of 1st NearBy Beacon Device with Highest Signal Strength,dummy data
    Near_Car_Beacon_Packet.Near_Car2_Beacon_Signal_Strength = 0x08;   //Signal Strength of 3rd NearBy Beacon Device with Highest Signal Strength          
    for(i=0;i<6;i++)
        Near_Car_Beacon_Packet.Near_Car3_Beacon_ID[i] = (1+i);         //MAC ID of 1st NearBy Beacon Device with Highest Signal Strength,dummy data
    Near_Car_Beacon_Packet.Near_Car3_Beacon_Signal_Strength = 0x09;   //Signal Strength of 3rd NearBy Beacon Device with Highest Signal Strength          
    Vehicle_Status_Lora_Packet.Sequence_No = 0x01;                   //Sent Packet Sequence Number
    Vehicle_Status_Lora_Packet.FCS = 0x00;                       //FCS of all packets     
    
    /******* Initialize Lora packet for CheckIn *****/
    Misc_Packet_Data.Header = LORA_PACKET_HEADER;
    Misc_Packet_Data.Protocol_Version = OBD_Protocol_Version;
    CheckIN_Lora_Packet.Packet_Type = CHECKIN_PACKET_CMD;
    for(i=0;i<5;i++)
        CheckIN_Lora_Packet.DTC[i] = 0x00;       //Get Beacon_ID of 1st nearby Beacon Device
    CheckIN_Lora_Packet.Sequence_No = 0x01;                   //Sent Packet Sequence Number
    CheckIN_Lora_Packet.FCS = 0x00;                       //FCS of all packets     
       
    /******* Initialize Lora packet for CheckOUT *****/
    Misc_Packet_Data.Header = LORA_PACKET_HEADER;
    Misc_Packet_Data.Protocol_Version = OBD_Protocol_Version;
    CheckOUT_Packet.Packet_Type = CHECKIN_PACKET_CMD;
    CheckOUT_Packet.Sequence_No = 0x01;                   //Sent Packet Sequence Number
    CheckOUT_Packet.FCS = 0x00;                       //FCS of all packets     
       
    /******* Initialize Lora packet for Movement *****/
    Misc_Packet_Data.Header = LORA_PACKET_HEADER;
    Misc_Packet_Data.Protocol_Version = OBD_Protocol_Version;
    Motion_Lora_Packet.Packet_Type = MOTION_PACKET_CMD;
    Motion_Lora_Packet.Acceleration_Type = 0x00;          //Type of acceleration, Vehicle Started/Vehicle Stopped/Sudden Vehicle Movement
    Motion_Lora_Packet.Sequence_No = 0x01;                   //Sent Packet Sequence Number
    Motion_Lora_Packet.FCS = 0x00;                        //FCS of all packets  
    Lora_Packet_To_Send[0] = 0x41;//'A'
    Lora_Packet_To_Send[1] = 0x54;//'T'
    Lora_Packet_To_Send[2] = 0x2b;//'+'
    Lora_Packet_To_Send[3] = 0x53;//'S'
    Lora_Packet_To_Send[4] = 0x45;//'E'
    Lora_Packet_To_Send[5] = 0x4e;//'N'
    Lora_Packet_To_Send[6] = 0x44;//'D'
    Lora_Packet_To_Send[7] = 0x20;//' ' Blank Space
    Lora_Packet_To_Send[8] = Misc_Packet_Data.Header;                  //Header of Lora Packet,0xFE
    Lora_Packet_To_Send[9] = Misc_Packet_Data.Protocol_Version;
    pc2.printf("\nLora Packets Initialized");
}
               
 //HeartBeat Packet should be sent every 30sec
void Send_HeartBeat_Packet(void)
{
    //write code to read obd data,temperature,beacon data
    uint8 Pos = 10,i;
    Lora_Packet_To_Send[Pos++] = Heart_Beat_Lora_Packet.Packet_Type;      //MSB of Motion Packet Type
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.OBD_Battery_Voltage >> 8);     //Get OBD_Battery Voltage
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.OBD_Battery_Voltage & 0xFF);     //Get OBD_Battery Voltage
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.Car_Battery_Voltage >> 8); //Get Vehicle_Battery Temperature
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.Car_Battery_Voltage & 0xFF); //Get Vehicle_Battery Temperature
    Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.OBD_Battery_Temperature;     //Get Battery Temperature
    Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.Car_Ambient_Temperature;     //Get Ambient Temperature
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking1_Beacon_ID[i];       //Get Beacon_ID of 1st nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking1_Beacon_Signal_Strength; //Get Signal Strength of 1st nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking2_Beacon_ID[i];       //Get Beacon_ID of 2nd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking2_Beacon_Signal_Strength; //Get Signal Strength of 2nd nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking3_Beacon_ID[i];       //Get Beacon_ID of 3rd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking3_Beacon_Signal_Strength; //Get Signal Strength of 3rd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Heart_Beat_Lora_Packet.Sequence_No;                  //Packet Sequence number
    //Lora_Packet_To_Send[Pos++] = Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xFA;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0x0D;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    /*Lora_Packet_To_Send[Pos++] = 0xB1;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xB2;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xB3;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xB4;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    */Packet_Type_To_Send = HEARTBEAT_TYPE_PACKET;
    Send_Lora_Packet_To_Gateway(Lora_Packet_To_Send,Pos); 
    if(Heart_Beat_Lora_Packet.Sequence_No < 0x08)
        Heart_Beat_Lora_Packet.Sequence_No++;
    else
        Heart_Beat_Lora_Packet.Sequence_No = 0x01;
    pc2.printf("\nHeartbeat Packet Sequence Number %d",Heart_Beat_Lora_Packet.Sequence_No);
    pc_2.printf("\nHeartbeat Packet Sequence Number %d",Heart_Beat_Lora_Packet.Sequence_No);
}

//CheckIN packets sending should be started when device is plugged in to the vehicle. It should be sent every 5sec for 2minutes and afterthat it should stop sending
void Send_Vehicle_Status_Packet(void)
{
    //write code to read OBD data,temperature,beacon data
    uint8 Pos = 10,i;
    Lora_Packet_To_Send[Pos++] = STATUS_PACKET_CMD;      //MSB of Motion Packet Type
    for(i=0;i < 17;i++)
        Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.VIN[i];           //Get OBD_ID
    for(i=0;i < 3;i++)
        Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.ODO_METER_READING[i];           //Get OBD_ID
    Lora_Packet_To_Send[Pos++] = (Vehicle_Status_Lora_Packet.Fuel_Level >> 8);     //Get OBD_Battery Voltage
    Lora_Packet_To_Send[Pos++] = (Vehicle_Status_Lora_Packet.Fuel_Level & 0xFF);     //Get OBD_Battery Voltage
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.OBD_Battery_Voltage >> 8);     //Get OBD_Battery Voltage
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.OBD_Battery_Voltage & 0xFF);     //Get OBD_Battery Voltage
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.Car_Battery_Voltage >> 8); //Get Vehicle_Battery Temperature
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.Car_Battery_Voltage & 0xFF); //Get Vehicle_Battery Temperature
    Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.OBD_Battery_Temperature;     //Get Battery Temperature
    Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.Car_Ambient_Temperature;     //Get Ambient Temperature
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking1_Beacon_ID[i];       //Get Beacon_ID of 1st nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking1_Beacon_Signal_Strength; //Get Signal Strength of 1st nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking2_Beacon_ID[i];       //Get Beacon_ID of 2nd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking2_Beacon_Signal_Strength; //Get Signal Strength of 2nd nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking3_Beacon_ID[i];       //Get Beacon_ID of 3rd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking3_Beacon_Signal_Strength; //Get Signal Strength of 3rd nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car1_Beacon_ID[i];       //Get Beacon_ID of 1st nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car1_Beacon_Signal_Strength; //Get Signal Strength of 1st nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car2_Beacon_ID[i];       //Get Beacon_ID of 2nd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car2_Beacon_Signal_Strength; //Get Signal Strength of 2nd nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car3_Beacon_ID[i];       //Get Beacon_ID of 3rd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = 0x23;//Near_Car_Beacon_Packet.Near_Car3_Beacon_Signal_Strength; //Get Signal Strength of 3rd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Vehicle_Status_Lora_Packet.Sequence_No;                  //Packet Sequence number
    /*Lora_Packet_To_Send[Pos++] = 0xEE;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEa;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEb;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEc;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEE;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xE3;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEb;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xE1;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xE5;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEa;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEb;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEf;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEE;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEa;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEb;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEc;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEE;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xE3;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEb;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xE1;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xE5;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEE;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEa;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEb;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xE9;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEE;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xE8;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xEb;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xE7;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    */Lora_Packet_To_Send[Pos++] = Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0x0D;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    /*Lora_Packet_To_Send[Pos++] = 0xA1;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xA2;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xA3;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0xA4;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    */Send_Lora_Packet_To_Gateway(Lora_Packet_To_Send,Pos); 
    if(Vehicle_Status_Lora_Packet.Sequence_No < 0x08)
        Vehicle_Status_Lora_Packet.Sequence_No++;
    else
        Vehicle_Status_Lora_Packet.Sequence_No = 0x01;
        pc2.printf("\nStatus Packet sending");
     pc2.printf("\nStatus Packet Sequence Number %d",Vehicle_Status_Lora_Packet.Sequence_No);
     pc_2.printf("\nStatus Packet Sequence Number %d",Vehicle_Status_Lora_Packet.Sequence_No);
}

//CheckIN packets sending should be started when device is plugged in to the vehicle. It should be sent every 5sec for 2minutes and afterthat it should stop sending
void Send_CheckIN_Packet(void)
{
    //write code to read OBD data,temperature,beacon data
    uint8 Pos = 10,i;
    Lora_Packet_To_Send[Pos++] = CHECKIN_PACKET_CMD;      //Check detected. Set packet type to Checkout type
    for(i=0;i < 17;i++)
        Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.VIN[i];           //Get OBD_ID
    for(i=0;i < 3;i++)
        Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.ODO_METER_READING[i];           //Get OBD_ID
    for(i=0;i<5;i++)
        Lora_Packet_To_Send[Pos++] = CheckIN_Lora_Packet.DTC[i];       //Get Beacon_ID of 1st nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.OBD_Battery_Voltage >> 8);     //Get OBD_Battery Voltage
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.OBD_Battery_Voltage & 0xFF);     //Get OBD_Battery Voltage
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.Car_Battery_Voltage >> 8); //Get Vehicle_Battery Temperature
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.Car_Battery_Voltage & 0xFF); //Get Vehicle_Battery Temperature
    Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.OBD_Battery_Temperature;     //Get Battery Temperature
    Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.Car_Ambient_Temperature;     //Get Ambient Temperature
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking1_Beacon_ID[i];       //Get Beacon_ID of 1st nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking1_Beacon_Signal_Strength; //Get Signal Strength of 1st nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking2_Beacon_ID[i];       //Get Beacon_ID of 2nd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking2_Beacon_Signal_Strength; //Get Signal Strength of 2nd nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking3_Beacon_ID[i];       //Get Beacon_ID of 3rd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking3_Beacon_Signal_Strength; //Get Signal Strength of 3rd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = CheckIN_Lora_Packet.Sequence_No;                  //Packet Sequence number
    Lora_Packet_To_Send[Pos++] = Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0x0D;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    CheckIN_Packet_Sent_Count++;
    Send_Lora_Packet_To_Gateway(Lora_Packet_To_Send,Pos); 
    pc2.printf("\nCheckIN Packet Sent");
    if(CheckIN_Lora_Packet.Sequence_No < 0x08)
        CheckIN_Lora_Packet.Sequence_No++;
    else
        CheckIN_Lora_Packet.Sequence_No = 0x01;
        pc2.printf("\nStatus Packet sending");
    pc2.printf("\nCheckIN Packet Sequence Number %d",CheckIN_Lora_Packet.Sequence_No);
}


//CheckIN packets sending should be started when device is plugged in to the vehicle. It should be sent every 5sec for 2minutes and afterthat it should stop sending
void Send_CheckOUT_Packet(void)
{
    //write code to read OBD data,temperature,beacon data
    uint8 Pos = 10,i;
    Lora_Packet_To_Send[Pos++] = CHECKOUT_PACKET_CMD;      //Checkout detected. Set packet type to Checkout type
    for(i=0;i < 17;i++)
        Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.VIN[i];           //Get OBD_ID
    for(i=0;i < 3;i++) 
        Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.ODO_METER_READING[i];           //Get OBD_ID
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.OBD_Battery_Voltage >> 8);     //Get OBD_Battery Voltage
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.OBD_Battery_Voltage & 0xFF);     //Get OBD_Battery Voltage
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.Car_Battery_Voltage >> 8); //Get Vehicle_Battery Temperature
    Lora_Packet_To_Send[Pos++] = (Misc_Packet_Data.Car_Battery_Voltage & 0xFF); //Get Vehicle_Battery Temperature
    Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.OBD_Battery_Temperature;     //Get Battery Temperature
    Lora_Packet_To_Send[Pos++] = Misc_Packet_Data.Car_Ambient_Temperature;     //Get Ambient Temperature
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking1_Beacon_ID[i];       //Get Beacon_ID of 1st nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking1_Beacon_Signal_Strength; //Get Signal Strength of 1st nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking2_Beacon_ID[i];       //Get Beacon_ID of 2nd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking2_Beacon_Signal_Strength; //Get Signal Strength of 2nd nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking3_Beacon_ID[i];       //Get Beacon_ID of 3rd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking3_Beacon_Signal_Strength; //Get Signal Strength of 3rd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = CheckOUT_Packet.Sequence_No;                  //Packet Sequence number
    Lora_Packet_To_Send[Pos++] = Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Lora_Packet_To_Send[Pos++] = 0x0D;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    CheckIN_Packet_Sent_Count++;
    Send_Lora_Packet_To_Gateway(Lora_Packet_To_Send,Pos); 
    pc2.printf("\nCheckOUT Packet Sent");
    if(CheckOUT_Packet.Sequence_No < 0x08)
        CheckOUT_Packet.Sequence_No++;
    else
        CheckOUT_Packet.Sequence_No = 0x01;
    pc2.printf("\CheckOUT Packet Sequence Number %d",CheckOUT_Packet.Sequence_No);
}

//Motion packets sending should be started when vehicle acceleration changes like when it starts moving,stops moving and gets sudden jurk in case of theft.
// It should be sent every 30sec for 2minutes and afterthat it should stop sending
void Send_Motion_Packet(void)
{
    //write code to read accelerometer data,temperature,beacon data
    uint8 Pos = 10,i;
    Lora_Packet_To_Send[Pos++] = MOTION_PACKET_CMD;//(Motion_Lora_Packet.Packet_Type & 0xFF);         //LSB of Motion Packet Type
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking1_Beacon_ID[i];       //Get Beacon_ID of 1st nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking1_Beacon_Signal_Strength; //Get Signal Strength of 1st nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking2_Beacon_ID[i];       //Get Beacon_ID of 2nd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking2_Beacon_Signal_Strength; //Get Signal Strength of 2nd nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking3_Beacon_ID[i];       //Get Beacon_ID of 3rd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Fixed_Beacon_Packet.Parking3_Beacon_Signal_Strength; //Get Signal Strength of 3rd nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car1_Beacon_ID[i];       //Get Beacon_ID of 1st nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car1_Beacon_Signal_Strength; //Get Signal Strength of 1st nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Motion_Lora_Packet.Acceleration_Type;       //get Type of Acceleration
    /*for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car1_Beacon_ID[i];       //Get Beacon_ID of 1st nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car1_Beacon_Signal_Strength; //Get Signal Strength of 1st nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car2_Beacon_ID[i];       //Get Beacon_ID of 2nd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car2_Beacon_Signal_Strength; //Get Signal Strength of 2nd nearby Beacon Device
    for(i=0;i<6;i++)
        Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car3_Beacon_ID[i];       //Get Beacon_ID of 3rd nearby Beacon Device
    Lora_Packet_To_Send[Pos++] = Near_Car_Beacon_Packet.Near_Car3_Beacon_Signal_Strength; //Get Signal Strength of 3rd nearby Beacon Device
    */Lora_Packet_To_Send[Pos++] = Motion_Lora_Packet.Sequence_No;                  //Packet Sequence number
    Lora_Packet_To_Send[Pos++] = Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Motion_Packet_Sent_Count++;
    Lora_Packet_To_Send[Pos++] = 0x0D;//Calculate_Lora_Frame_FCS(Lora_Packet_To_Send,Pos);   //Calculate FCS of all bytes
    Send_Lora_Packet_To_Gateway(Lora_Packet_To_Send,Pos); 
    if(Motion_Lora_Packet.Sequence_No < 0x08)
        Motion_Lora_Packet.Sequence_No++;
    else
        Motion_Lora_Packet.Sequence_No = 0x01;
     pc2.printf("\n Motion Packet Sent");
     pc2.printf("\Motion Packet Sequence Number %d",Motion_Lora_Packet.Sequence_No);
}   


void Get_Lora_Response(void)
{
    static uint16 Temp_Pos1,Temp_pos2;
    static uint8 Lora_Response_Found = 0x00; 
    static uint8 Response_Start_Pos[5];
    Lora_Response_Found = 0;
    Temp_Pos1 = LORA_UART_RX_Crnt_Pos = 0;
    while(Temp_Pos1 < Lora_RxBuffer_End_Pos) 
    { //check for end of AT response to calculate length
        if((LORA_UART_RX_Buffer[Temp_Pos1] != 0x0D) || (LORA_UART_RX_Buffer[Temp_Pos1+1] != 0x0A)) 
        { //check for  AT end response <cr><lf> (i.e. 0x0D,0x0A)
            Temp_Pos1++;
        }
        else
        {
            Temp_Pos1+=2;
            Response_Start_Pos[Lora_Response_Found++] = Temp_Pos1;
            /*pc2.printf("\nEcho data\n");
            for(Temp_pos2 = LORA_UART_RX_Crnt_Pos;Temp_pos2<Temp_Pos1;Temp_pos2++)
                pc2.printf("0x%2x ",(LORA_UART_RX_Buffer[Temp_pos2]));*/
            if(Lora_Response_Found >= 4)
                break;
        }
    }
    if(Lora_Response_Found >= 3)
    {
        if((Response_Start_Pos[1] - Response_Start_Pos[0]) > 0x02) //Response received without data
        {
            LORA_UART_RX_Crnt_Pos = (Response_Start_Pos[0]);
            Response_Start_Pos[1]-=2;
            for(Temp_Pos1=0; LORA_UART_RX_Crnt_Pos < Response_Start_Pos[1]; Temp_Pos1++)
            {
                Lora_Command_Rcvd[Temp_Pos1] = LORA_UART_RX_Buffer[LORA_UART_RX_Crnt_Pos++];
            }
            Lora_RxBuffer_End_Pos = 0;
            AT_Response_Receive_Status = SUCCESS;
        }
        else if((Response_Start_Pos[1] - Response_Start_Pos[0]) == 0x02) //Response received along with data
        {
            LORA_UART_RX_Crnt_Pos = (Response_Start_Pos[1]);
            Response_Start_Pos[2]-=2;
            for(Temp_Pos1=0; LORA_UART_RX_Crnt_Pos < Response_Start_Pos[2]; Temp_Pos1++)
            {
                Lora_Command_Rcvd[Temp_Pos1] = LORA_UART_RX_Buffer[LORA_UART_RX_Crnt_Pos++];
            }
            Lora_RxBuffer_End_Pos = 0;
            AT_Response_Receive_Status = SUCCESS;
        }
    }
}

//Function to send general Lora packets using "AT+SEND" Command
void Send_Lora_Packet_To_Gateway(uint8* Command_To_Send,uint8 Length)
{
     uint8 i=0;
     pc2.printf("\nSending command");
     for(i=0; i < Length; i++)
     {
        LORA_Module_UART.putc(Command_To_Send[i]);
        pc2.printf("0x%2x ",(Command_To_Send[i]));
     }
     //LORA_Module_UART.printf("\r");
     /*
     pc2.printf("\n Sending packet\n");
     for(i=0; i < Length; i++)
     {
        pc2.printf("0x%2x ",(Command_To_Send[i]));
     }
     */
     // LORA_Module_UART.printf("%s",Command_To_Send);
     pc2.printf("\nTotal Bytes %d\n",Length);
}

/*
//Function to send general Lora packets using "AT+SEND" Command
void Send_Lora_Packet_To_Gateway(uint8* Command_To_Send,uint8 Length)
{
    uint8 i=0;
    //pc2.printf("Sending data");
   // LORA_Module_UART.printf("%s",Send_Lora_Packet);//write to serial port for sending through lora module
     /*for(i=0; i < 7; i++)
     {
        LORA_Module_UART.putc(Send_Lora_Packet[i]);
        
     }
     for(i=0; i < Length; i++)
     {
        LORA_Module_UART.putc(Command_To_Send[i]);
        pc2.putc(Command_To_Send[i]);
     }
     for(i=0; i < Length; i++)
     {
        pc2.putc(Command_To_Send[i]);
        
     }
     
   // LORA_Module_UART.printf("%s",Command_To_Send);
    LORA_Module_UART.printf("\r");
    pc2.printf("Total Bytes %d",Length);
}*/

 unsigned char Calculate_Lora_Frame_FCS(unsigned char* Packet_Data,unsigned char Packet_Length)
 {
     uint8 i,FCS = 0x00;
     for(i=0; i < Packet_Length; i++)
     {
        FCS ^= (Packet_Data[i]);
     }
     return(FCS);
 }
