/**
 * @brief first thread control program with  MBED OS
 */
#include "mbed.h"
#include "rtos.h"

#define THREAD_A "thread_a"
#define THREAD_B "thread_b"
#define THREAD_C "thread_c"

InterruptIn checkinIntr(PC_13);
InterruptIn motionIntr(PC_14);

DigitalOut led1(LED1);
DigitalOut led2(PA_11);
DigitalOut led3(PA_12); 

/* reserve the debbuger uart to shell interface */
Serial pc_serial(USBTX,USBRX);

/* declares threads for this demo: */
const size_t a_stk_size = 512;
uint8_t a_stk[a_stk_size];
Thread a_thread(osPriorityNormal, a_stk_size, &a_stk[0]);

const size_t b_stk_size = 512;
uint8_t b_stk[b_stk_size];
Thread b_thread(osPriorityNormal, b_stk_size, &b_stk[0]);

const size_t c_stk_size = 512;
uint8_t c_stk[c_stk_size];
Thread c_thread(osPriorityNormal, c_stk_size, &c_stk[0]);

const size_t e_stk_size = 512;
uint8_t e_stk[e_stk_size];
Thread checkinEventThread(osPriorityNormal, e_stk_size, &e_stk[0]);
Thread motionEventThread(osPriorityNormal, e_stk_size, &e_stk[0]);

// create an event queue
EventQueue chechinEventQueue;
EventQueue motionEventQueue;
 
uint32_t count = 0;

void checkinFunction() {
  // this now runs in the context of checkinEventThread, instead of in the ISR
  count++;
  printf("Toggling LED!\r\n");
  for(int i = 0 ; i < 0xFFFFFF; i++);
  led3 = !led3;
  printf("Toggled LED count = %d \r\n", count);
}

void motionFunction() {
  // this now runs in the context of checkinEventThread, instead of in the ISR
  count++;
  printf("Toggling LED!\r\n");
  for(int i = 0 ; i < 0xFFFFFF; i++);
  led3 = !led3;
  printf("Toggled LED count = %d \r\n", count);
}

/**
 * @brief thread a function 
 */
static void thread(void const *buf)
{
    uint32_t execs = 0;
    pc_serial.printf("## started %s execution! ##\n\r", (char *)buf);
 
    for(;;) {
        execs++;
        /* adds dummy processing */
        for(int i = 0 ; i < 0xFFFFFF; i++);
        pc_serial.printf("## %s executed %d times! ##\n\r", (char *)buf, execs);
        led1 = !led1;
        Thread::yield();
    }
}

static void thread2(void const *buf)
{
    uint32_t execs = 0;
    pc_serial.printf("## started %s execution! ##\n\r", (char *)buf);
 
    for(;;) {
        execs++;
        /* adds dummy processing */
        for(int i = 0 ; i < 0xF00000; i++);
        pc_serial.printf("## %s executed %d times! ##\n\r", (char *)buf, execs);
        led2 = !led2;
        Thread::yield();
    }
}

static void thread3(void const *buf)
{
    uint32_t execs = 0;
    pc_serial.printf("## started %s execution! ##\n\r", (char *)buf);
 
    for(;;) {
        execs++;
        /* adds dummy processing */
        for(int i = 0 ; i < 0xFFFFFF; i++);
        pc_serial.printf("## %s executed %d times! ##\n\r", (char *)buf, execs);
        led3 = !led3;
        Thread::yield();
    }
}

/**
 * @brief main application loop
 */
int main(void) 
{      
    pc_serial.baud(115200);
    a_thread.start(callback(thread, (void *)THREAD_A));
    b_thread.start(callback(thread2, (void *)THREAD_B));
    /*c_thread.start(callback(thread3, (void *)THREAD_C));*/
    
    checkinEventThread.start(callback(&chechinEventQueue, &EventQueue::dispatch_forever));
    motionEventThread.start(callback(&motionEventQueue, &EventQueue::dispatch_forever));
 
    // wrap calls in queue.event to automatically defer to the queue's thread
    checkinIntr.fall(chechinEventQueue.event(&checkinFunction));
    motionIntr.fall(motionEventQueue.event(&motionFunction));
  
  
    return 0;
}
