#include "mbed.h"
#include <string>

Serial pc(USBTX, USBRX);
Serial wifi(p28,p27);
Timer t;

DigitalOut myled(LED1);

int initializeWifi();

bool IsHttpRequest(char* buffer);

bool IsItHttpGetMethod(char* buffer);

void serverResponse();

void ServerGetMethodResponse(string dataString);

void ProcessHttpGetMethod(char* buffer);

int main() {
    pc.baud(115200);
    wifi.baud(115200);
    pc.printf("Ready to boil!\r\n");
    initializeWifi();
    
    size_t MaxBufferSize = 2048;
    char buffer[MaxBufferSize];
    
    // local variables:
    char currentChar = 0;
    char prevChar = 0;
    int bufferIndex = 0;
    while(1) {
        
        // get some input to wifi device from pc:
        if(pc.readable()){
            wifi.putc(pc.getc());
        }
        
        // read data from wifi device:
        if(wifi.readable()){
            
            prevChar = currentChar;
            currentChar = wifi.getc();
            pc.putc(currentChar);
            
            // Manage input buffer / prevent from overflow:
            if(bufferIndex < MaxBufferSize)
            {
                buffer[bufferIndex] = currentChar;
                bufferIndex++;
            }
            else
            {
                memset(buffer, 0, MaxBufferSize);
                bufferIndex = 0;
            }
            
            //pc.printf("*DEBUG* => before test.");
            // detect new CR-LF:
            if(currentChar == 10 && prevChar == 13)
            {
                //pc.printf("*DEBUG* => riched CR-LF");
                //pc.printf("Buff val: %s\r\n", buffer);
                // Process input buffer:
                if(IsHttpRequest(buffer))
                {
                    //pc.printf("*DEBUG* => Is HTTP request.");
                    bool proccessNow = IsItHttpGetMethod(buffer);
                    if(proccessNow)
                    {
                        ProcessHttpGetMethod(buffer);
                        
                        // clean up:
                        memset(buffer, 0, MaxBufferSize);
                        bufferIndex = 0;
                    }
                }
            }
        } 
    }
}

bool IsItHttpGetMethod(char* buffer)
{
    //pc.printf("asdasd: %s\r\n", buffer);
    if(strstr(buffer, "GET") != NULL)
    {
        return true;
    }
    
    return false;
}


bool IsHttpRequest(char* buffer)
{
    //pc.printf("asdasd: %s\r\n", buffer);
    if(strstr(buffer, "HTTP") != NULL)
    {
        return true;
    }
    
    return false;
}


int initializeWifi(){
    t.reset();
    t.start();
    wifi.printf("AT+RST\r\n"); 
    while(t.read() < 0.2){ 
        while(wifi.readable()) pc.putc(wifi.getc());
    }
    t.stop();
    wifi.printf("AT+CWJAP=\"Liutauras WiFi\",\"12345678\"\r\n");
    t.reset();
    t.start();
    while(t.read() < 7){
        while(wifi.readable()) pc.putc(wifi.getc());  
    } 
    t.stop();
    t.reset();
    wifi.printf("AT+CIFSR\r\n");
    t.start();
    while(t.read() < 0.2){
        while(wifi.readable()) pc.putc(wifi.getc());  
    }
     
    t.stop();
    t.reset();
    wifi.printf("AT+CIPMUX=1\r\n");
    t.start();
    while(t.read() < 0.2){
        while(wifi.readable()) pc.putc(wifi.getc());  
    } 
    
    t.stop();
    t.reset();
    wifi.printf("AT+CIPSERVER=1,80\r\n");
    t.start();
    while(t.read() < 0.2){
        while(wifi.readable()) pc.putc(wifi.getc());  
    }
    return true;  
}

void ProcessHttpGetMethod(char* buffer)
{
    const string GetStatusMethod = "GetStatus";
    
    if(strstr(buffer, "GetStatus") != NULL)
    {
        //pc.printf("*DEBUG* => oid ProcessHttpGetMethod(char* buffer)");
        ServerGetMethodResponse("Boiling: 0; Temp: 37; Weigth: 500");
        return;
    }
    
    //pc.printf("*DEBUG* => after if ProcessHttpGetMethod(char* buffer)");
    ServerGetMethodResponse("No data");
}

void ServerGetMethodResponse(string dataString){
    
    string version = "HTTP/1.1 200 OK\r\n";
    //string status = "200 OK\r\n";
    //string server = "Server: SuperBoiler\r\n";
    string contentType = "Content-Type: text/html;\r\n";
    string connection = "Connection: close\r\n";
    //string contentLength = "Content-Length:
    string blank = "\r\n";
    string data = dataString;
    
    //status.length()
    //server.length()
    size_t responseLen = version.length() + contentType.length() + connection.length() + blank.length() + data.length();
    
    wifi.printf("AT+CIPSEND=0,%d\r\n", responseLen);
    t.reset();
    t.start();
    while(t.read() < 0.2){
        while(wifi.readable()) pc.putc(wifi.getc());  
    }  
    t.stop();
    
    pc.printf("%s", version);
    //pc.printf("%s", status);
    //pc.printf("%s", server);
    pc.printf("%s", contentType);
    pc.printf("%s", connection);
    pc.printf("%s", blank);
    pc.printf("%s", data);
    
    wifi.printf("%s", version);
    //wifi.printf("%s", status);
    //wifi.printf("%s", server);
    wifi.printf("%s", contentType);
    wifi.printf("%s", connection);
    wifi.printf("%s", blank);
    wifi.printf("%s", data);  
    
    wait(1);
   wifi.printf("AT+CIPCLOSE\r\n");
    t.reset();
    t.start();
    while(t.read() < 1){
        while(wifi.readable()) pc.putc(wifi.getc());  
    }  
    t.stop();      
}
