#include "mbed.h"


float _scale;
DigitalOut myled(LED_BLUE);

DigitalIn HX_DOUT(PTC3);
DigitalOut HX_PD_SCK(PTC5);

Serial pc(USBTX, USBRX);
long offset = 0;
long ReadWeight(void);
//double getGram();
uint16_t getGram();
long getAverageValue(int times);

int main()
{
    offset = getAverageValue(20);
    int i = 0;
    pc.printf("Hello World!\n");
    while (true) {
        wait(0.5f); // wait a small period of time
        pc.printf("%d \n", getGram()); // print the value of variable i
        i++; // increment the variable
        myled = !myled; // toggle a led
    }
}

long ReadWeight(void)
{
        long Count;
        unsigned char i;
        HX_PD_SCK.write(0);
        Count = 0;
        while(HX_DOUT.read() == 1);
        for (i=0;i<24;i++)
        {
                HX_PD_SCK.write(1);
                Count=Count<<1;
                HX_PD_SCK.write(0);
                if(HX_DOUT.read() == 1) Count++;
        }
        HX_PD_SCK.write(1);
        Count=Count^0x800000;
        HX_PD_SCK.write(0);
        return(Count);
}

//double getGram(){
//    return ((getAverageValue(20) - offset)*0.0000407059);//8409088
//    //return getAverageValue(20);// - offset)*0.00793457031);//8409088
//
//}

uint16_t getGram(){
    return ((getAverageValue(20) - offset))/1000;//*0.0000407059);//8409088
    //return getAverageValue(20);// - offset)*0.00793457031);//8409088

}

long getAverageValue(int times){
    long sum = 0;
    for (int i = 0; i < times; i++)
    {
        sum += ReadWeight();
    }
    return sum / times;
}

