#include "mbed.h"
#include "Hexi_KW40Z.h"
#include "Hexi_OLED_SSD1351.h"
#include "OLED_types.h"
#include "OpenSans_Font.h"
#include "string.h"

#define LED_ON      0
#define LED_OFF     1

   
void StartHaptic(void);
void StopHaptic(void const *n);
void txTask(void);
long ReadWeight(void);
uint16_t getGram();
long offset = 0;
long getAverageValue(int times);

// Pin connections for Hexiwear
//MPL3115A2 MPL3115A2( PTC11, PTC10, MPL3115A2_I2C_ADDRESS);
/* pos [0] = altimeter or pressure value */
/* pos [1] = temperature value */
float sensor_data[2];

DigitalOut redLed(LED1,1);
DigitalOut greenLed(LED2,1);
DigitalOut blueLed(LED3,1);
DigitalOut haptic(PTB9);

DigitalIn HX_DOUT(PTC3);
DigitalOut HX_PD_SCK(PTC5);

/* Define timer for haptic feedback */
RtosTimer hapticTimer(StopHaptic, osTimerOnce);

/* Instantiate the Hexi KW40Z Driver (UART TX, UART RX) */ 
KW40Z kw40z_device(PTE24, PTE25);

/* Instantiate the SSD1351 OLED Driver */ 
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); /* (MOSI,SCLK,POWER,CS,RST,DC) */

/*Create a Thread to handle sending BLE Sensor Data */ 
Thread txThread;

 /* Text Buffer */ 
char text[20]; 

/****************************Call Back Functions*******************************/
void ButtonRight(void)
{
    StartHaptic();
    kw40z_device.ToggleAdvertisementMode();
}

void ButtonLeft(void)
{
    StartHaptic();
    kw40z_device.ToggleAdvertisementMode();
}

void PassKey(void)
{
    StartHaptic();
    strcpy((char *) text,"PAIR CODE");
    oled.TextBox((uint8_t *)text,0,25,95,18);
  
    /* Display Bond Pass Key in a 95px by 18px textbox at x=0,y=40 */
    sprintf(text,"%d", kw40z_device.GetPassKey());
    oled.TextBox((uint8_t *)text,0,40,95,18);
}

/***********************End of Call Back Functions*****************************/

/********************************Main******************************************/

int main()
{    
    Thread::wait(10000);
    offset = getAverageValue(20);
    /* Get OLED Class Default Text Properties */
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);    

    /* Turn on the backlight of the OLED Display */
    oled.DimScreenON();
    
    /* Fills the screen with solid black */         
    oled.FillScreen(COLOR_BLACK);
        
    /* Register callbacks to application functions */
    kw40z_device.attach_buttonLeft(&ButtonLeft);
    kw40z_device.attach_buttonRight(&ButtonRight);
    kw40z_device.attach_passkey(&PassKey);

    /* Change font color to white */ 
    textProperties.fontColor   = COLOR_WHITE;
    oled.SetTextProperties(&textProperties);
    
    /* Display Bluetooth Label at x=17,y=30 */ 
    strcpy((char *) text,"89.9kg");
    oled.Label((uint8_t *)text,17,30);
    
    
    /* Change font color to Blue */ 
    textProperties.fontColor   = COLOR_BLUE;
    oled.SetTextProperties(&textProperties);
    
    /* Display Bluetooth Label at x=17,y=65 */ 
    strcpy((char *) text,"BLUETOOTH");
    oled.Label((uint8_t *)text,17,65);
    
    /* Change font color to white */ 
    textProperties.fontColor   = COLOR_WHITE;
    textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
    oled.SetTextProperties(&textProperties);
    
    /* Display Label at x=22,y=80 */ 
    strcpy((char *) text,"Tap Below");
    oled.Label((uint8_t *)text,22,80);
         
    uint8_t prevLinkState = 0; 
    uint8_t currLinkState = 0; 
    txThread.start(txTask); /*Start transmitting Sensor Tag Data */
    
    while (true) 
    {
        blueLed = !kw40z_device.GetAdvertisementMode(); /*Indicate BLE Advertisment Mode*/   
        Thread::wait(50);
    }
}

/******************************End of Main*************************************/


/* txTask() transmits the sensor data */
void txTask(void){
   
   while (true) 
   {
        /* sets the gain of hx711 to 128*/
        ReadWeight();
        
        /*Notify Hexiwear App that it is running Sensor Tag mode*/
        kw40z_device.SendSetApplicationMode(GUI_CURRENT_APP_SENSOR_TAG);

        /*Send weight using pressure service*/ 
        kw40z_device.SendPressure(getGram());      
        Thread::wait(1000);                 
    }
}

void StartHaptic(void)  {
    hapticTimer.start(50);
    haptic = 1;
}

void StopHaptic(void const *n) {
    haptic = 0;
    hapticTimer.stop();
}

long ReadWeight(void)
{
        long Count;
        unsigned char i;
        HX_PD_SCK.write(0);
        Count = 0;
        while(HX_DOUT.read() == 1);
        for (i=0;i<24;i++)
        {
                HX_PD_SCK.write(1);
                Count=Count<<1;
                HX_PD_SCK.write(0);
                if(HX_DOUT.read() == 1) Count++;
        }
        HX_PD_SCK.write(1);
        Count=Count^0x800000;
        HX_PD_SCK.write(0);
        return(Count);
}

uint16_t getGram(){
    return ((getAverageValue(20) - offset))/1000;
}

long getAverageValue(int times){
    long sum = 0;
    for (int i = 1; i <= times; i++)
    {
        sum += ReadWeight();
    }
    return sum / times;
}





