//--------------------------------------------------------------
//  SD_WavReader class ---- Header
//      SD カードの *.wav ファイルの内容を読み出す
//      以下のフォーマット以外は扱わない
//          PCM，16 ビットステレオ，標本化周波数 44.1 kHz
//
//  2016/04/19, Copyright (c) 2016 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef SD_WAV_READER_HPP
#define SD_WAV_READER_HPP

#include "SDFileSystem.h"
#include "BlinkLabel.hpp"
#include <string>

namespace Mikami
{
    class SD_WavReader
    {
    public:
        SD_WavReader(int32_t bufferSize);
        ~SD_WavReader();

        void Open(const string fileName);
        
        void Close() { fclose(fp_); }
        
        // ファイルのヘッダ (RIFFxxxxWAVEfm ) 読み込み
        //      戻り値： *.wav で，16 ビットステレオ，
        //             標本化周波数：44.1 kHz の場合 true
        bool IsWavFile();

        // ファイルからデータの取得
        void Read(int16_t data[], uint32_t size);

        // ファイルからデータをモノラルに変換しての取得
        void ReadAndToMono(int16_t data[], uint32_t size);
        
        // データサイズ（標本化点の数）の取得
        int32_t GetSize();
        
        // ren: show a string        
/*       void ren_Msg1(int pos, char msg[])
        {  int lin, str_ln, y_pos[7]= {0,70,130,160,190,220,250};
//        char msg[501];
//        strcpy(msg, str_msg.c_str());
//        str_ln=str_msg.size();
//        if(str_ln>500) str_ln=500;
//        msg[str_ln]='\0';
        if(pos<0) lin=0;
        else if (pos>6)  lin=6;
        else lin=pos;
        Label renLabel(0, y_pos[lin], msg, Label::LEFT,Font20);
        }  
*/
    private:
        const string STR_;
        
        struct WaveFormatEx
        {
            uint16_t wFormatTag;        // 1: PCM
            uint16_t nChannels;         // 1：モノラル，2: ステレオ
            uint32_t nSamplesPerSec;    // 標本化周波数 (Hz)
            uint32_t nAvgBytesPerSec;   // 転送速度 (bytes/s)
            uint16_t nBlockAlign;       // 4: 16ビットステレオの場合
            uint16_t wBitsPerSample;    // データのビット数，8 または 16
            uint16_t cbSize;
        };

        SDFileSystem *sd_;
        FILE *fp_;
        
        bool ok_;
        int32_t size_;      // モノラルデータのサイズ
        int16_t *buffer;    // ステレオをモノラルに変換する際の作業領域
        
        void ErrorMsg(char msg[])
        {   BlinkLabel errLabel(240, 100, msg, Label::CENTER); }

        // disallow copy constructor and assignment operator
        SD_WavReader(const SD_WavReader&);
        SD_WavReader& operator=(const SD_WavReader&);
    };
}
#endif  // SD_BINARY_READER_HPP
