//--------------------------------------------------------------
//  グラフィックイコライザ付き SD オーディオプレーヤーで使う大域関数（ヘッダ）
//
//  2016/05/09, Copyright (c) 2016 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef F746_MY_FUNCTIONS_HPP
#define F746_MY_FUNCTIONS_HPP

#include "SAI_InOut.hpp"
#include "ButtonGroup.hpp"
#include "FileSelectorWav.hpp"
#include "DesignerDrawer.hpp"
#include "SD_WavReader.hpp"
#include "SeekbarGroup.hpp"
#include "BiquadGrEq.hpp"

using namespace Mikami;

// １フレーム分の信号処理 (イコライザ) の実行
void SignalProcessing(SD_WavReader &sdReader, SaiIO &mySai,
                      int16_t sn[], BiquadGrEq hn[],
                      int stages, bool on);

// SD カードのファイルのオープン
int32_t SD_Open(SD_WavReader &sdReader,
                string fileName, int32_t frameSize);

// ファイルの選択
void SelectFile(ButtonGroup &menu, FileSelector &selector,
                Label &msg, string fileList[], int *selected);

// フィルタの変更
void ModifyFilter(DesignerDrawer &drawerObj,
                  SeekbarGroup &myBars, BiquadGrEq hn[],
                  Button &flat, ButtonGroup &onOff, bool &on);

#endif  // F746_MY_FUNCTIONS_HPP
