//--------------------------------------------------------------
//  グラフィックイコライザ付き SD オーディオプレーヤーで使う大域関数
//
//  2016/05/09, Copyright (c) 2016 MIKAMI, Naoki
//--------------------------------------------------------------

#include "MyFunctions.hpp"

// １フレーム分の信号処理 (イコライザ) の実行
void SignalProcessing(SD_WavReader &sdReader, SaiIO &mySai,
                      int16_t sn[], BiquadGrEq hn[],
                      int stages, bool on)
{
    // １フレーム分のデータを SD から読み込む
    sdReader.ReadAndToMono(sn, mySai.GetLength());

    while (!mySai.IsXferred()) {}   // データの転送が終わるまで待つ
    //--------------------------------------------------------------
    // １フレーム分のイコライザ処理を行い，その結果を出力する
    for (int n=0; n<mySai.GetLength(); n++)
    {
        // 縦続形の IIR フィルタ実行
        float xn = 0.125f*sn[n];    // 0.125 の乗算はブースとしてもクリップ
                                    // されないようにするため
        float yn = xn;
        for (int k=0; k<stages; k++) yn = hn[k].Execute(yn);
        int16_t value = on ? (int16_t)yn : xn;
        mySai.Output(value, value); // 音響信号の出力
    }
    //--------------------------------------------------------------
    mySai.ResetXferred();   // 次のデータ転送に備える
}

// SD カードのファイルのオープン
int32_t SD_Open(SD_WavReader &sdReader,
                string fileName, int32_t frameSize)
{
    sdReader.Open(fileName);
    sdReader.IsWavFile();
    return sdReader.GetSize()/frameSize;
}

// ファイルの選択
//      selectedName:   選択されたファイル名
void SelectFile(ButtonGroup &menu, FileSelector &selector,
                Label &msg, string fileList[], int *selected)
{
    selector.DisplayFileList(*selected);   
    msg.Draw("Select file");
    do
    {
        if (selector.Select(fileList, selected))
            menu.Activate(1);   // PLAY 有効
 // ren: change wait timer 200 to 60
        wait_ms(60);
    } while (!menu.Touched(1)); // PLAY がタッチされるまで繰り返す
}

// フィルタの周波数特性の変更
void ModifyFilter(DesignerDrawer &drawerObj,
                  SeekbarGroup &myBars, BiquadGrEq hn[],
                  Button &flat, ButtonGroup &onOff, bool &on)
{

    // 周波数特性を平坦化
    if (flat.Touched())
    {
        drawerObj.DrawFlat();
        for (int n=0; n<drawerObj.GetStages(); n++)
            hn[n] = BiquadGrEq(drawerObj.GetCoefficient(n));
        myBars.DrawAll(0);  // ツマミの位置を 0 dB に設定する
        flat.Draw();
        return;
    }

    int sw = 0;
    if (onOff.GetTouchedNumber(sw))
        on = (sw == 0) ? true : false;

    static int num = 0;
    if (!myBars.GetSlidedNumber(num)) return;
    drawerObj.DesignAndRedraw(myBars.GetValue(num), num);
    hn[num] = BiquadGrEq(drawerObj.GetCoefficient(num));
}
