//--------------------------------------------------------------
//  グラフィックイコライザで使う 1D タイプの 2 次のフィルタ
//  Biquad filter of 1D type for graphic equalizer
//      このクラスでは，係数は実行中に書き換えられることを想定している
//
//      u[n] = x[n] + a1*u[n-1] + a2*u[n-2]
//      y[n] = b0*u[n] + b1*u[n-1] + b2*u[n-2]
//          x[n] :  input signal
//          y[n] :  output signal
//
// 2016/03/25, Copyright (c) 2016 MIKAMI, Naoki
//--------------------------------------------------------------

#ifndef IIR_BIQUAD_HPP
#define IIR_BIQUAD_HPP

#include "mbed.h"

// 2nd order IIR filter
namespace Mikami
{
    class BiquadGrEq
    {
    public:
        struct Coefs { float a1, a2, b0, b1, b2; };

        BiquadGrEq() {}     // Default constructore

        BiquadGrEq(const Coefs ck)
        {
            SetCoefficients(ck);
            Clear();
        }
        
        void SetCoefficients(const Coefs ck)
        {
            a1_ = ck.a1;
            a2_ = ck.a2;
            b0_ = ck.b0;
            b1_ = ck.b1;
            b2_ = ck.b2;
        }

        float Execute(float xn)
        {
            float un = xn + a1_*un1_ + a2_*un2_;
            float yn = b0_*un + b1_*un1_ + b2_*un2_;
        
            un2_ = un1_;
            un1_ = un;

            return yn;
        }

        void Clear() { un1_ = un2_ = 0; }

    private:
        float a1_, a2_, b0_, b1_, b2_;
        float un1_, un2_;

        // disallow copy constructor
        BiquadGrEq(const BiquadGrEq&);
    };
}
#endif  // IIR_BIQUAD_HPP

