//-----------------------------------------------------------
//  グラフィックイコライザで使う IIR フィルタの周波数応答
//  Frequency response for graphic equalizer
//
//  2016/04/27, Copyright (c) 2016 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef GRAPHIC_EQUALIZER_FREQUENCY_RESPONSE_HPP
#define GRAPHIC_EQUALIZER_FREQUENCY_RESPONSE_HPP

#include "FrequancyResponseBase.hpp"
#include "BiquadGrEq.hpp"

namespace Mikami
{
    class GrEqualizerFrqResp : public FrequencyResponse
    {
    public:
        GrEqualizerFrqResp(int stages) : STAGES_(stages)
        {   ck_ = new BiquadGrEq::Coefs[stages];  }
        
        ~GrEqualizerFrqResp()
        {   delete[] ck_; }

        // フィルタの係数設定
        void SetParams(BiquadGrEq::Coefs ck[])
        {   for (int n=0; n<STAGES_; n++) ck_[n] = ck[n]; }
        
        void SetParam(BiquadGrEq::Coefs ck, int n)
        {   ck_[n] = ck; }

        // 周波数応答の絶対値を返す関数, 引数: z^(-1)
        virtual float AbsH_z(Complex u)
        {
            Complex h = 1;
            for (int k=0; k<STAGES_; k++)
            h = h*(ck_[k].b0 + (ck_[k].b1 + ck_[k].b2*u)*u)
                /((1.0f - (ck_[k].a1 + ck_[k].a2*u)*u));
            return abs(h);       
        }

    private:
        const int STAGES_;
        float g0_;
        BiquadGrEq::Coefs *ck_;

        // disallow copy constructor and assignment operator
        GrEqualizerFrqResp(const GrEqualizerFrqResp&);
        GrEqualizerFrqResp& operator=(const GrEqualizerFrqResp&);
    };
}
#endif  // GRAPHIC_EQUALIZER_FREQUENCY_RESPONSE_HPP
