//-----------------------------------------------------------
//  ButtonGroup class -- Header
//
//  2016/04/21, Copyright (c) 2016 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef F746_BUTTON_GROUP_HPP
#define F746_BUTTON_GROUP_HPP

#include "Button.hpp"

namespace Mikami
{
    class ButtonGroup : public GuiBase
    {
    public:
        // Constructor
        ButtonGroup(uint16_t x0, uint16_t y0,
                    uint16_t width, uint16_t height,
                    uint16_t number, const string str[],
                    uint16_t spaceX = 0, uint16_t spaceY = 0,
                    uint16_t column = 1,
                    int touched = -1,   // number for button initially touched-color
                    bool expanded = false,
                    sFONT &fonts = Font12,
                    uint32_t textColor         = GuiBase::ENUM_TEXT,
                    uint32_t backColor         = GuiBase::ENUM_BACK,
                    uint32_t createdColor      = GuiBase::ENUM_CREATED,
                    uint32_t touchedColor      = GuiBase::ENUM_TOUCHED,
                    uint32_t inactiveColor     = GuiBase::ENUM_INACTIVE,
                    uint32_t inactiveTextColor = GuiBase::ENUM_INACTIVE_TEXT);

        // Destructor
        ~ButtonGroup();

        // Draw button
        bool Draw(int num, uint32_t color, uint32_t textColor);
        bool Draw(int num) { return Draw(num, CREATED_COLOR_, TEXT_COLOR_); }

        // Change to touched color
        bool TouchedColor(int num);

        // Draw all buttons
        void DrawAll(uint32_t color, uint32_t textColor)
        {
            for (int n=0; n<numberOfButtons_; n++)
                buttons_[n]->Draw(color, textColor);
        }
        void DrawAll() { DrawAll(CREATED_COLOR_, TEXT_COLOR_); }

        // Erase button
        bool Erase(int num);

        // Check touch detected for specified button
        bool Touched(int num);

        // Get touched number
        bool GetTouchedNumber(int &num);

        // Activate and inactivate
        bool Activate(int num);
        bool Inactivate(int num);
        void ActivateAll()
        {   
            for (int n=0; n<numberOfButtons_; n++)
                buttons_[n]->Activate();
        }
        void InactivateAll()
        {
            for (int n=0; n<numberOfButtons_; n++)
                buttons_[n]->Inactivate();
        }

    private:
        Button **buttons_;
        int numberOfButtons_;
        __IO int prevNum_;

        // Check range of argument
        bool Range(int n)
        { return ((n >= 0) && (n < numberOfButtons_)); }

        // disallow copy constructor and assignment operator
        ButtonGroup(const ButtonGroup&);
        ButtonGroup& operator=(const ButtonGroup&);
    };
}
#endif  // F746_BUTTON_GROUP_HPP
