# Platform Abstraction Layer R1.0 Release Notes

## Introduction
This version is the first release of the Platform Abstraction Layer (PAL) package. The target of PAL is to support easy porting of the mbed Cloud Client services to different platforms and operating systems. 
The version also includes a reference porting to the mbedOS 5.2 (mbed-os-5.2) operating system, running on Cortex-M SoC.

## Content
Version R1.0 includes the following features:

1. Service APIs:
  A set of APIs to be used by the mbed Cloud Client services. Currently supported:
  1. RTOS API: OS primitives: Threads, Semaphores, memory pools, ...
  2. Network API: networking API. Supporting TCP & UDP in synchronous & asynchronous modes. 

2. Platform APIs
  Set of APIs the platform owner is expected to implement for the specific device and operating system.

3. Documentation:
  1. API documentation
  2. Porting guide
  
3. Reference implementation of the Platform APIs for the mbedOS 5.2 (mbed-os-5.2) OS.

## Release
Unless differently stated in file, the PAL package is released as an Open Source, under the Apache-2.0 license model. You can find a copy of the license [here](https://github.com/ARMmbed/pal/blob/master/apache-2.0.txt).

The repository of PAL can be found at: https://github.com/ARMmbed/pal

The Release tag is: PAL-R1.0

## Known issues
No known issues exists at the time of release.

Since not all interfaces needed by the services are covered yet, we assume [mbedTLS](https://tls.mbed.org) is supplied by the platform.

## Reporting issues
Please report any issue on the PAL GitHub project.
