/* KL25Z mbed library for ILI9341 touch devices
 * SPI Interface

 * Uses Peter Drescher ILI9341 Library
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


#include "touch.h"
#include "mbed.h"


TouchScreen::TouchScreen(PinName xp, PinName yp, PinName xm, PinName ym) {
    }
    

int TouchScreen::readTouch(PinName a, PinName i, PinName n, PinName m){
    
    AnalogIn   _a(a);
    AnalogIn   _i(i);
    DigitalOut _n(n);
    DigitalOut _m(m);
    int a1=1;
    int a2=0;
    _n = 1;
    _m = 0;
    wait_us(50);
    a1 = _a.read_u16();
    wait_us(50);
    a2 = _a.read_u16();
    wait_us(50);
    _n=0;
    return (a1+a2)/2;
}


                
int map(float value, float fromSource, float toSource, float fromTarget, float toTarget){
        return (value - fromSource) / (toSource - fromSource) * (toTarget - fromTarget) + fromTarget;
}