/*


*/

#ifndef MBED_SERVO_H
#define MBED_SERVO_H
#include "mbed.h"

class Servo {

public:
    Servo(PinName pin);
    void write(float percent);
    void setRange(float maxrange, float minrange);
    void setMax();
    void setMin();
    float read();
    void position(float degrees);
    
    /**  Allows calibration of the range and angles for a particular servo
     *
     * @param range Pulsewidth range from center (1.5ms) to maximum/minimum position in seconds
     * @param degrees Angle from centre to maximum/minimum position in degrees
     */
    //range : 1.5msを中心とした、最大最小までのパルス幅の指定
    //degrees : 中心から最大最小までの角度の指定
    void calibrate(float range = 0.0005, float degrees = 45.0); 
        
    /**  Shorthand for the write and read functions */
    Servo& operator= (float percent);
    Servo& operator= (Servo& rhs);
    operator float();

protected:
    PwmOut _pwm;
    float _range;
    float _degrees;
    float _p;
    float maxRange, minRange;
};

#endif
