/*
ver1.0
Sbdbt Name(tx,rx)
sbdbtに接続するtx,rx

ver2.0
Sbdbt Name(tx,rx)
sbdbtに接続するtx,rx

begin(baudrate)
sbdbtと通信するbaudrateを決定

ボタンデータ 0/1
shikaku, l1, l2, r1, r2, start, select, 
up, down, right, left, sankaku, batu, maru

アナログスティックデータ -1 ~ 1
left_x, left_y, right_x, right_y;

sbdbtから受信したデータ
open_data[data_byte];
*/

#ifndef MBED_SBDBT_H
#define MBED_SBDBT_H

#include "mbed.h"
#include "bit_test.h"

#define start_byte 0b10000000
#define Shikaku 0
#define L1      1
#define L2      2
#define R1      3
#define R2      4
#define Start   0b00000011
#define Select  0b00001100
#define Up      0
#define Down    1
#define Right   2
#define Left    3
#define Sankaku 4
#define Batu    5
#define Maru    6
#define EvenNeutral 0b01000000
#define OddNeutral  0b00111111
#define data_byte  8
#define input_byte 7

class Sbdbt{
public  :
    Sbdbt(PinName mbed_tx, PinName mbed_rx, PinName pin_pairing);
    void begin(long baudrate);
    int get_pairingState();
    
    short shikaku;
    short l1;
    short l2;
    short r1;
    short r2;
    short start;
    short select;
    short up;
    short down;
    short right;
    short left;
    short sankaku;
    short batu;
    short maru;
    float left_x;
    float left_y;
    float right_x;
    float right_y;
    int open_data[data_byte];
    
private :
    Serial SBDBT;
    DigitalIn pairing;
    
    int read, data_start, checksum, byte,
        buffer[data_byte], data[data_byte];
    int Left_X, Left_Y, Right_X, Right_Y ;
    
    void init();
    void check();
    void data_receive();
};

#endif