/***************
RS422 master libraly

RS422 name(tx, rx)
tx : mbed_tx
rx : mbed_rx

put(int id, float m1_duty, float m2_duty)
id   : NucleoのID 0~31
duty : モータにかけるPWMのDuty -1.0~1.0

****************/

#ifndef MBED_RS422_PUT_H
#define MBED_RS422_PUT_H

#include "mbed.h"

#define start_signal    0b11111111
#define wait_time       0.0005


class Rs422
{
public :
    Rs422(PinName mbed_tx, PinName mbed_rx);

    void begin(int baudrate);

    void put(short id, float m1_duty, float m2_duty);

private :
    Serial RS422;
    Ticker timer;

    short flag;
    int counter;
    int m1_data,m2_data,check_sum;
    int ID;

    void put_time();
};

#endif