/*
[Encorder]
    **PositionPidを継承しているバージョン
    **エンコーダICからの出力を読み取りPprを指定することで, pulse, deg, rad, 回転数などを出力
    **ターゲット角度を指定することでPID制御を通した出力値(-1.0~0.0~1.0)出力できる
   
[Public Member Functions]
    Encoder (PinName A_Phase, PinName B_Phase);
        **<Create> 宣言
    
    void setup(float Kp, float Ki, float Kd, float dt);
        **PIDのパラメータを設定
        
    void cal(float target, float dt);
        **calを行うことでデータを更新できる
    
    float duty();
        **PID計算を行ったモーターへの出力値(-1.0~1.0)を出力 
    
    float duty_enableWidth(float duty_min, float duty_max);
        **PID計算を行ったモーターへの出力値(-1.0~1.0)を出力
        **引数でduty値を0と基準としたときの前後を指定することで、ストールさせないようにする
        
    void setPpr(int Ppr);
        **エンコーダのPPRを指定
    
    float deg();
        **設定したPPRに基づきdegを出力
    
    float get_deg_cylinder();
        **cylinder用のdegを出力  //基本的に17roboの大会用
        
    float rad();
        **設定したPPRに基づきradを出力
    
    int pulse();
        **設定したPPRに基づきradを出力
        
    float N();
        **設定したPPRに基づき回転数を出力
        
    void origin();
        **エンコーダ読み取り数を原点に指定する
 */
 
#ifndef MBED_PID_ENCORDER_H
#define MBED_PID_ENCORDER_H

#include "pid.h"
#include "mbed.h"

#define PI      3.141592654f
#define Nmax    18000
#define invalidN    0.1

class Encoder : public PositionPid //: public Speed_pid
{
public:
    Encoder (PinName A_Phase, PinName B_Phase);
    void setPpr(int Ppr);    
    void cal(float target, float dt);
    float deg();    
    float get_deg_cylinder();
    float rad();
    int pulse();
    float N();
    void origin();
    
private :
    InterruptIn A;
    InterruptIn B;

    int ppr;
    signed int count;
    float radian,oldtheta;
    float w,v,n;
    float degree, deg_cylinder;

    void A_count();
    void B_count();
};

#endif