/*********************************************
PID library

PositionPid : 位置型
SpeedPid    : 速度型

setup(float Kp, float Ki, float Kd, float dt)
パラメータ、制御周期の設定
Kp : Pゲイン
Ki : Iゲイン
Kd : Dゲイン
dt : 制御周期[s]

calculate(float target, float nowValue)
PIDの計算をする
target   : 目標値
nowValue : 現在値

duty()
計算結果を-1~1で返す
*********************************************/

#ifndef MBED_PID_H
#define MBED_PID_H

#include "mbed.h"

class PositionPid
{
public  :
    void setup(float Kp, float Ki, float Kd, float dt);

    void calculate(float target, float nowValue);

    float duty();
    
    float duty_enableWidth(float duty_min, float duty_max);

private :
    float kp, ki, kd,
          time, frequency,
          old, now,
          p, i, d, result;
};

class SpeedPid
{
public  :
    void setup(float Kp, float Ki, float Kd, float dt);

    void calculate(float target, float nowValue);

    float duty();

private :
    float kp, ki, kd,
          time, frequency,
          e, e1, e2,
          p, i, d, result;
};

#endif