/*
MotorDrive Name(cw_ccw, pwm);

setup(float frequency, float acceleration, float timerCycle);
MotorDrive関数のセットアップ
frequency    : pwmの周波数[Hz]
acceleration : 加速度[m/s^2]
timerCycle   : outputを呼び出す周期[s]

output(duty)
dutyになるように出力する
*/

#ifndef MBED_MOTOR_DRIVE_H
#define MBED_MOTOR_DRIVE_H

#include "mbed.h"

#define DUTY_LIMIT   0.95

class MotorDrive
{
public  :
    MotorDrive (PinName Direction,PinName Pwm);

    void setup(float frequency, float acceleration, float timerCycle);

    void output(float targetDuty);

private :
    DigitalOut direction;
    PwmOut pwm;
    float a;
    float duty;
};

#endif